/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest;

public class DescribeStaleSecurityGroupsRequestMarshaller
implements Marshaller<Request<DescribeStaleSecurityGroupsRequest>, DescribeStaleSecurityGroupsRequest> {
    public Request<DescribeStaleSecurityGroupsRequest> marshall(DescribeStaleSecurityGroupsRequest describeStaleSecurityGroupsRequest) {
        if (describeStaleSecurityGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeStaleSecurityGroupsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeStaleSecurityGroups");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeStaleSecurityGroupsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeStaleSecurityGroupsRequest.maxResults()));
        }
        if (describeStaleSecurityGroupsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeStaleSecurityGroupsRequest.nextToken()));
        }
        if (describeStaleSecurityGroupsRequest.vpcId() != null) {
            request.addParameter("VpcId", StringConversion.fromString((String)describeStaleSecurityGroupsRequest.vpcId()));
        }
        return request;
    }
}

