/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeLaunchTemplatesRequestMarshaller
implements Marshaller<Request<DescribeLaunchTemplatesRequest>, DescribeLaunchTemplatesRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<DescribeLaunchTemplatesRequest> marshall(DescribeLaunchTemplatesRequest describeLaunchTemplatesRequest) {
        List<Filter> describeLaunchTemplatesRequestFiltersList;
        List<String> describeLaunchTemplatesRequestLaunchTemplateNamesList;
        if (describeLaunchTemplatesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeLaunchTemplatesRequest, "Ec2Client");
        request.addParameter("Action", "DescribeLaunchTemplates");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeLaunchTemplatesRequestLaunchTemplateIdsList = describeLaunchTemplatesRequest.launchTemplateIds();
        if (!describeLaunchTemplatesRequestLaunchTemplateIdsList.isEmpty() || !(describeLaunchTemplatesRequestLaunchTemplateIdsList instanceof SdkAutoConstructList)) {
            int launchTemplateIdsListIndex = 1;
            for (String string : describeLaunchTemplatesRequestLaunchTemplateIdsList) {
                if (string != null) {
                    request.addParameter("LaunchTemplateId." + launchTemplateIdsListIndex, StringConversion.fromString((String)string));
                }
                ++launchTemplateIdsListIndex;
            }
        }
        if (!(describeLaunchTemplatesRequestLaunchTemplateNamesList = describeLaunchTemplatesRequest.launchTemplateNames()).isEmpty() || !(describeLaunchTemplatesRequestLaunchTemplateNamesList instanceof SdkAutoConstructList)) {
            int launchTemplateNamesListIndex = 1;
            for (String describeLaunchTemplatesRequestLaunchTemplateNamesListValue : describeLaunchTemplatesRequestLaunchTemplateNamesList) {
                if (describeLaunchTemplatesRequestLaunchTemplateNamesListValue != null) {
                    request.addParameter("LaunchTemplateName." + launchTemplateNamesListIndex, StringConversion.fromString((String)describeLaunchTemplatesRequestLaunchTemplateNamesListValue));
                }
                ++launchTemplateNamesListIndex;
            }
        }
        if (!(describeLaunchTemplatesRequestFiltersList = describeLaunchTemplatesRequest.filters()).isEmpty() || !(describeLaunchTemplatesRequestFiltersList instanceof SdkAutoConstructList)) {
            boolean bl = true;
            for (Filter describeLaunchTemplatesRequestFiltersListValue : describeLaunchTemplatesRequestFiltersList) {
                List<String> filterValuesList;
                void var6_12;
                if (describeLaunchTemplatesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + (int)var6_12 + ".Name", StringConversion.fromString((String)describeLaunchTemplatesRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeLaunchTemplatesRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + (int)var6_12 + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++var6_12;
            }
        }
        if (describeLaunchTemplatesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeLaunchTemplatesRequest.nextToken()));
        }
        if (describeLaunchTemplatesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeLaunchTemplatesRequest.maxResults()));
        }
        return request;
    }
}

