/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeLaunchTemplateVersionsRequestMarshaller
implements Marshaller<Request<DescribeLaunchTemplateVersionsRequest>, DescribeLaunchTemplateVersionsRequest> {
    public Request<DescribeLaunchTemplateVersionsRequest> marshall(DescribeLaunchTemplateVersionsRequest describeLaunchTemplateVersionsRequest) {
        List<Filter> describeLaunchTemplateVersionsRequestFiltersList;
        List<String> describeLaunchTemplateVersionsRequestVersionsList;
        if (describeLaunchTemplateVersionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeLaunchTemplateVersionsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeLaunchTemplateVersions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeLaunchTemplateVersionsRequest.launchTemplateId() != null) {
            request.addParameter("LaunchTemplateId", StringConversion.fromString((String)describeLaunchTemplateVersionsRequest.launchTemplateId()));
        }
        if (describeLaunchTemplateVersionsRequest.launchTemplateName() != null) {
            request.addParameter("LaunchTemplateName", StringConversion.fromString((String)describeLaunchTemplateVersionsRequest.launchTemplateName()));
        }
        if (!(describeLaunchTemplateVersionsRequestVersionsList = describeLaunchTemplateVersionsRequest.versions()).isEmpty() || !(describeLaunchTemplateVersionsRequestVersionsList instanceof SdkAutoConstructList)) {
            int versionsListIndex = 1;
            for (String describeLaunchTemplateVersionsRequestVersionsListValue : describeLaunchTemplateVersionsRequestVersionsList) {
                if (describeLaunchTemplateVersionsRequestVersionsListValue != null) {
                    request.addParameter("LaunchTemplateVersion." + versionsListIndex, StringConversion.fromString((String)describeLaunchTemplateVersionsRequestVersionsListValue));
                }
                ++versionsListIndex;
            }
        }
        if (describeLaunchTemplateVersionsRequest.minVersion() != null) {
            request.addParameter("MinVersion", StringConversion.fromString((String)describeLaunchTemplateVersionsRequest.minVersion()));
        }
        if (describeLaunchTemplateVersionsRequest.maxVersion() != null) {
            request.addParameter("MaxVersion", StringConversion.fromString((String)describeLaunchTemplateVersionsRequest.maxVersion()));
        }
        if (describeLaunchTemplateVersionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeLaunchTemplateVersionsRequest.nextToken()));
        }
        if (describeLaunchTemplateVersionsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeLaunchTemplateVersionsRequest.maxResults()));
        }
        if (!(describeLaunchTemplateVersionsRequestFiltersList = describeLaunchTemplateVersionsRequest.filters()).isEmpty() || !(describeLaunchTemplateVersionsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeLaunchTemplateVersionsRequestFiltersListValue : describeLaunchTemplateVersionsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeLaunchTemplateVersionsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeLaunchTemplateVersionsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeLaunchTemplateVersionsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

