/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeFleetInstancesRequestMarshaller
implements Marshaller<Request<DescribeFleetInstancesRequest>, DescribeFleetInstancesRequest> {
    public Request<DescribeFleetInstancesRequest> marshall(DescribeFleetInstancesRequest describeFleetInstancesRequest) {
        List<Filter> describeFleetInstancesRequestFiltersList;
        if (describeFleetInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeFleetInstancesRequest, "Ec2Client");
        request.addParameter("Action", "DescribeFleetInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeFleetInstancesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeFleetInstancesRequest.maxResults()));
        }
        if (describeFleetInstancesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeFleetInstancesRequest.nextToken()));
        }
        if (describeFleetInstancesRequest.fleetId() != null) {
            request.addParameter("FleetId", StringConversion.fromString((String)describeFleetInstancesRequest.fleetId()));
        }
        if (!(describeFleetInstancesRequestFiltersList = describeFleetInstancesRequest.filters()).isEmpty() || !(describeFleetInstancesRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeFleetInstancesRequestFiltersListValue : describeFleetInstancesRequestFiltersList) {
                List<String> filterValuesList;
                if (describeFleetInstancesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeFleetInstancesRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeFleetInstancesRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

