/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateVolumeRequest;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagSpecification;

public class CreateVolumeRequestMarshaller
implements Marshaller<Request<CreateVolumeRequest>, CreateVolumeRequest> {
    public Request<CreateVolumeRequest> marshall(CreateVolumeRequest createVolumeRequest) {
        List<TagSpecification> createVolumeRequestTagSpecificationsList;
        if (createVolumeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createVolumeRequest, "Ec2Client");
        request.addParameter("Action", "CreateVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVolumeRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringConversion.fromString((String)createVolumeRequest.availabilityZone()));
        }
        if (createVolumeRequest.encrypted() != null) {
            request.addParameter("Encrypted", StringConversion.fromBoolean((Boolean)createVolumeRequest.encrypted()));
        }
        if (createVolumeRequest.iops() != null) {
            request.addParameter("Iops", StringConversion.fromInteger((Integer)createVolumeRequest.iops()));
        }
        if (createVolumeRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringConversion.fromString((String)createVolumeRequest.kmsKeyId()));
        }
        if (createVolumeRequest.size() != null) {
            request.addParameter("Size", StringConversion.fromInteger((Integer)createVolumeRequest.size()));
        }
        if (createVolumeRequest.snapshotId() != null) {
            request.addParameter("SnapshotId", StringConversion.fromString((String)createVolumeRequest.snapshotId()));
        }
        if (createVolumeRequest.volumeTypeAsString() != null) {
            request.addParameter("VolumeType", StringConversion.fromString((String)createVolumeRequest.volumeTypeAsString()));
        }
        if (!(createVolumeRequestTagSpecificationsList = createVolumeRequest.tagSpecifications()).isEmpty() || !(createVolumeRequestTagSpecificationsList instanceof SdkAutoConstructList)) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createVolumeRequestTagSpecificationsListValue : createVolumeRequestTagSpecificationsList) {
                List<Tag> tagSpecificationTagsList;
                if (createVolumeRequestTagSpecificationsListValue.resourceTypeAsString() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringConversion.fromString((String)createVolumeRequestTagSpecificationsListValue.resourceTypeAsString()));
                }
                if (!(tagSpecificationTagsList = createVolumeRequestTagSpecificationsListValue.tags()).isEmpty() || !(tagSpecificationTagsList instanceof SdkAutoConstructList)) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.key() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagSpecificationTagsListValue.key()));
                        }
                        if (tagSpecificationTagsListValue.value() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagSpecificationTagsListValue.value()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

