/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest;

public class CreateNetworkInterfacePermissionRequestMarshaller
implements Marshaller<Request<CreateNetworkInterfacePermissionRequest>, CreateNetworkInterfacePermissionRequest> {
    public Request<CreateNetworkInterfacePermissionRequest> marshall(CreateNetworkInterfacePermissionRequest createNetworkInterfacePermissionRequest) {
        if (createNetworkInterfacePermissionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createNetworkInterfacePermissionRequest, "Ec2Client");
        request.addParameter("Action", "CreateNetworkInterfacePermission");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNetworkInterfacePermissionRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringConversion.fromString((String)createNetworkInterfacePermissionRequest.networkInterfaceId()));
        }
        if (createNetworkInterfacePermissionRequest.awsAccountId() != null) {
            request.addParameter("AwsAccountId", StringConversion.fromString((String)createNetworkInterfacePermissionRequest.awsAccountId()));
        }
        if (createNetworkInterfacePermissionRequest.awsService() != null) {
            request.addParameter("AwsService", StringConversion.fromString((String)createNetworkInterfacePermissionRequest.awsService()));
        }
        if (createNetworkInterfacePermissionRequest.permissionAsString() != null) {
            request.addParameter("Permission", StringConversion.fromString((String)createNetworkInterfacePermissionRequest.permissionAsString()));
        }
        return request;
    }
}

