/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.CreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMappingRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateCpuOptionsRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateEbsBlockDeviceRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplatePlacementRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateSpotMarketOptionsRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplatesMonitoringRequest;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification;
import software.amazon.awssdk.services.ec2.model.RequestLaunchTemplateData;
import software.amazon.awssdk.services.ec2.model.Tag;

public class CreateLaunchTemplateRequestMarshaller
implements Marshaller<Request<CreateLaunchTemplateRequest>, CreateLaunchTemplateRequest> {
    /*
     * Could not resolve type clashes
     */
    public Request<CreateLaunchTemplateRequest> marshall(CreateLaunchTemplateRequest createLaunchTemplateRequest) {
        RequestLaunchTemplateData launchTemplateData;
        if (createLaunchTemplateRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createLaunchTemplateRequest, "Ec2Client");
        request.addParameter("Action", "CreateLaunchTemplate");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLaunchTemplateRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)createLaunchTemplateRequest.clientToken()));
        }
        if (createLaunchTemplateRequest.launchTemplateName() != null) {
            request.addParameter("LaunchTemplateName", StringConversion.fromString((String)createLaunchTemplateRequest.launchTemplateName()));
        }
        if (createLaunchTemplateRequest.versionDescription() != null) {
            request.addParameter("VersionDescription", StringConversion.fromString((String)createLaunchTemplateRequest.versionDescription()));
        }
        if ((launchTemplateData = createLaunchTemplateRequest.launchTemplateData()) != null) {
            LaunchTemplateCpuOptionsRequest cpuOptions;
            CreditSpecificationRequest creditSpecification;
            LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions;
            List<String> requestLaunchTemplateDataSecurityGroupsList;
            List<String> requestLaunchTemplateDataSecurityGroupIdsList;
            List<ElasticGpuSpecification> requestLaunchTemplateDataElasticGpuSpecificationsList;
            List<LaunchTemplateTagSpecificationRequest> requestLaunchTemplateDataTagSpecificationsList;
            LaunchTemplatePlacementRequest placement;
            LaunchTemplatesMonitoringRequest monitoring;
            List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> requestLaunchTemplateDataNetworkInterfacesList;
            List<LaunchTemplateBlockDeviceMappingRequest> requestLaunchTemplateDataBlockDeviceMappingsList;
            LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile;
            if (launchTemplateData.kernelId() != null) {
                request.addParameter("LaunchTemplateData.KernelId", StringConversion.fromString((String)launchTemplateData.kernelId()));
            }
            if (launchTemplateData.ebsOptimized() != null) {
                request.addParameter("LaunchTemplateData.EbsOptimized", StringConversion.fromBoolean((Boolean)launchTemplateData.ebsOptimized()));
            }
            if ((iamInstanceProfile = launchTemplateData.iamInstanceProfile()) != null) {
                if (iamInstanceProfile.arn() != null) {
                    request.addParameter("LaunchTemplateData.IamInstanceProfile.Arn", StringConversion.fromString((String)iamInstanceProfile.arn()));
                }
                if (iamInstanceProfile.name() != null) {
                    request.addParameter("LaunchTemplateData.IamInstanceProfile.Name", StringConversion.fromString((String)iamInstanceProfile.name()));
                }
            }
            if (!(requestLaunchTemplateDataBlockDeviceMappingsList = launchTemplateData.blockDeviceMappings()).isEmpty() || !(requestLaunchTemplateDataBlockDeviceMappingsList instanceof SdkAutoConstructList)) {
                int blockDeviceMappingsListIndex = 1;
                for (Object requestLaunchTemplateDataBlockDeviceMappingsListValue : requestLaunchTemplateDataBlockDeviceMappingsList) {
                    LaunchTemplateEbsBlockDeviceRequest ebs;
                    if (((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).deviceName() != null) {
                        request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringConversion.fromString((String)((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).deviceName()));
                    }
                    if (((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).virtualName() != null) {
                        request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringConversion.fromString((String)((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).virtualName()));
                    }
                    if ((ebs = ((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).ebs()) != null) {
                        if (ebs.encrypted() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringConversion.fromBoolean((Boolean)ebs.encrypted()));
                        }
                        if (ebs.deleteOnTermination() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringConversion.fromBoolean((Boolean)ebs.deleteOnTermination()));
                        }
                        if (ebs.iops() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringConversion.fromInteger((Integer)ebs.iops()));
                        }
                        if (ebs.kmsKeyId() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.KmsKeyId", StringConversion.fromString((String)ebs.kmsKeyId()));
                        }
                        if (ebs.snapshotId() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringConversion.fromString((String)ebs.snapshotId()));
                        }
                        if (ebs.volumeSize() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringConversion.fromInteger((Integer)ebs.volumeSize()));
                        }
                        if (ebs.volumeTypeAsString() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringConversion.fromString((String)ebs.volumeTypeAsString()));
                        }
                    }
                    if (((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).noDevice() != null) {
                        request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringConversion.fromString((String)((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).noDevice()));
                    }
                    ++blockDeviceMappingsListIndex;
                }
            }
            if (!(requestLaunchTemplateDataNetworkInterfacesList = launchTemplateData.networkInterfaces()).isEmpty() || !(requestLaunchTemplateDataNetworkInterfacesList instanceof SdkAutoConstructList)) {
                int networkInterfacesListIndex = 1;
                for (LaunchTemplateInstanceNetworkInterfaceSpecificationRequest requestLaunchTemplateDataNetworkInterfacesListValue : requestLaunchTemplateDataNetworkInterfacesList) {
                    List<PrivateIpAddressSpecification> launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesList;
                    Object launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesList;
                    List<String> launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsList;
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.associatePublicIpAddress() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringConversion.fromBoolean((Boolean)requestLaunchTemplateDataNetworkInterfacesListValue.associatePublicIpAddress()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.deleteOnTermination() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringConversion.fromBoolean((Boolean)requestLaunchTemplateDataNetworkInterfacesListValue.deleteOnTermination()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.description() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".Description", StringConversion.fromString((String)requestLaunchTemplateDataNetworkInterfacesListValue.description()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.deviceIndex() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringConversion.fromInteger((Integer)requestLaunchTemplateDataNetworkInterfacesListValue.deviceIndex()));
                    }
                    if (!(launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsList = requestLaunchTemplateDataNetworkInterfacesListValue.groups()).isEmpty() || !(launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsList instanceof SdkAutoConstructList)) {
                        int groupsListIndex = 1;
                        for (Object launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue : launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsList) {
                            if (launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue != null) {
                                request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringConversion.fromString((String)launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue));
                            }
                            ++groupsListIndex;
                        }
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.ipv6AddressCount() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".Ipv6AddressCount", StringConversion.fromInteger((Integer)requestLaunchTemplateDataNetworkInterfacesListValue.ipv6AddressCount()));
                    }
                    if (!(launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesList = requestLaunchTemplateDataNetworkInterfacesListValue.ipv6Addresses()).isEmpty() || !(launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesList instanceof SdkAutoConstructList)) {
                        Object launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue;
                        int ipv6AddressesListIndex = 1;
                        launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue = launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesList.iterator();
                        while (launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue.hasNext()) {
                            InstanceIpv6AddressRequest launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesListValue = (InstanceIpv6AddressRequest)launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue.next();
                            if (launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesListValue.ipv6Address() != null) {
                                request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringConversion.fromString((String)launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesListValue.ipv6Address()));
                            }
                            ++ipv6AddressesListIndex;
                        }
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.networkInterfaceId() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringConversion.fromString((String)requestLaunchTemplateDataNetworkInterfacesListValue.networkInterfaceId()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.privateIpAddress() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringConversion.fromString((String)requestLaunchTemplateDataNetworkInterfacesListValue.privateIpAddress()));
                    }
                    if (!(launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesList = requestLaunchTemplateDataNetworkInterfacesListValue.privateIpAddresses()).isEmpty() || !(launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesList instanceof SdkAutoConstructList)) {
                        int privateIpAddressesListIndex = 1;
                        for (Object launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue : launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesList) {
                            if (((PrivateIpAddressSpecification)launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue).primary() != null) {
                                request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringConversion.fromBoolean((Boolean)((PrivateIpAddressSpecification)launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue).primary()));
                            }
                            if (((PrivateIpAddressSpecification)launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue).privateIpAddress() != null) {
                                request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringConversion.fromString((String)((PrivateIpAddressSpecification)launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue).privateIpAddress()));
                            }
                            ++privateIpAddressesListIndex;
                        }
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.secondaryPrivateIpAddressCount() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringConversion.fromInteger((Integer)requestLaunchTemplateDataNetworkInterfacesListValue.secondaryPrivateIpAddressCount()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.subnetId() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringConversion.fromString((String)requestLaunchTemplateDataNetworkInterfacesListValue.subnetId()));
                    }
                    ++networkInterfacesListIndex;
                }
            }
            if (launchTemplateData.imageId() != null) {
                request.addParameter("LaunchTemplateData.ImageId", StringConversion.fromString((String)launchTemplateData.imageId()));
            }
            if (launchTemplateData.instanceTypeAsString() != null) {
                request.addParameter("LaunchTemplateData.InstanceType", StringConversion.fromString((String)launchTemplateData.instanceTypeAsString()));
            }
            if (launchTemplateData.keyName() != null) {
                request.addParameter("LaunchTemplateData.KeyName", StringConversion.fromString((String)launchTemplateData.keyName()));
            }
            if ((monitoring = launchTemplateData.monitoring()) != null && monitoring.enabled() != null) {
                request.addParameter("LaunchTemplateData.Monitoring.Enabled", StringConversion.fromBoolean((Boolean)monitoring.enabled()));
            }
            if ((placement = launchTemplateData.placement()) != null) {
                if (placement.availabilityZone() != null) {
                    request.addParameter("LaunchTemplateData.Placement.AvailabilityZone", StringConversion.fromString((String)placement.availabilityZone()));
                }
                if (placement.affinity() != null) {
                    request.addParameter("LaunchTemplateData.Placement.Affinity", StringConversion.fromString((String)placement.affinity()));
                }
                if (placement.groupName() != null) {
                    request.addParameter("LaunchTemplateData.Placement.GroupName", StringConversion.fromString((String)placement.groupName()));
                }
                if (placement.hostId() != null) {
                    request.addParameter("LaunchTemplateData.Placement.HostId", StringConversion.fromString((String)placement.hostId()));
                }
                if (placement.tenancyAsString() != null) {
                    request.addParameter("LaunchTemplateData.Placement.Tenancy", StringConversion.fromString((String)placement.tenancyAsString()));
                }
                if (placement.spreadDomain() != null) {
                    request.addParameter("LaunchTemplateData.Placement.SpreadDomain", StringConversion.fromString((String)placement.spreadDomain()));
                }
            }
            if (launchTemplateData.ramDiskId() != null) {
                request.addParameter("LaunchTemplateData.RamDiskId", StringConversion.fromString((String)launchTemplateData.ramDiskId()));
            }
            if (launchTemplateData.disableApiTermination() != null) {
                request.addParameter("LaunchTemplateData.DisableApiTermination", StringConversion.fromBoolean((Boolean)launchTemplateData.disableApiTermination()));
            }
            if (launchTemplateData.instanceInitiatedShutdownBehaviorAsString() != null) {
                request.addParameter("LaunchTemplateData.InstanceInitiatedShutdownBehavior", StringConversion.fromString((String)launchTemplateData.instanceInitiatedShutdownBehaviorAsString()));
            }
            if (launchTemplateData.userData() != null) {
                request.addParameter("LaunchTemplateData.UserData", StringConversion.fromString((String)launchTemplateData.userData()));
            }
            if (!(requestLaunchTemplateDataTagSpecificationsList = launchTemplateData.tagSpecifications()).isEmpty() || !(requestLaunchTemplateDataTagSpecificationsList instanceof SdkAutoConstructList)) {
                int tagSpecificationsListIndex = 1;
                for (Object requestLaunchTemplateDataTagSpecificationsListValue : requestLaunchTemplateDataTagSpecificationsList) {
                    List<Tag> launchTemplateTagSpecificationRequestTagsList;
                    if (((LaunchTemplateTagSpecificationRequest)requestLaunchTemplateDataTagSpecificationsListValue).resourceTypeAsString() != null) {
                        request.addParameter("LaunchTemplateData.TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringConversion.fromString((String)((LaunchTemplateTagSpecificationRequest)requestLaunchTemplateDataTagSpecificationsListValue).resourceTypeAsString()));
                    }
                    if (!(launchTemplateTagSpecificationRequestTagsList = ((LaunchTemplateTagSpecificationRequest)requestLaunchTemplateDataTagSpecificationsListValue).tags()).isEmpty() || !(launchTemplateTagSpecificationRequestTagsList instanceof SdkAutoConstructList)) {
                        int tagsListIndex = 1;
                        for (Tag launchTemplateTagSpecificationRequestTagsListValue : launchTemplateTagSpecificationRequestTagsList) {
                            if (launchTemplateTagSpecificationRequestTagsListValue.key() != null) {
                                request.addParameter("LaunchTemplateData.TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)launchTemplateTagSpecificationRequestTagsListValue.key()));
                            }
                            if (launchTemplateTagSpecificationRequestTagsListValue.value() != null) {
                                request.addParameter("LaunchTemplateData.TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)launchTemplateTagSpecificationRequestTagsListValue.value()));
                            }
                            ++tagsListIndex;
                        }
                    }
                    ++tagSpecificationsListIndex;
                }
            }
            if (!(requestLaunchTemplateDataElasticGpuSpecificationsList = launchTemplateData.elasticGpuSpecifications()).isEmpty() || !(requestLaunchTemplateDataElasticGpuSpecificationsList instanceof SdkAutoConstructList)) {
                int elasticGpuSpecificationsListIndex = 1;
                for (ElasticGpuSpecification requestLaunchTemplateDataElasticGpuSpecificationsListValue : requestLaunchTemplateDataElasticGpuSpecificationsList) {
                    if (requestLaunchTemplateDataElasticGpuSpecificationsListValue.type() != null) {
                        request.addParameter("LaunchTemplateData.ElasticGpuSpecification." + elasticGpuSpecificationsListIndex + ".Type", StringConversion.fromString((String)requestLaunchTemplateDataElasticGpuSpecificationsListValue.type()));
                    }
                    ++elasticGpuSpecificationsListIndex;
                }
            }
            if (!(requestLaunchTemplateDataSecurityGroupIdsList = launchTemplateData.securityGroupIds()).isEmpty() || !(requestLaunchTemplateDataSecurityGroupIdsList instanceof SdkAutoConstructList)) {
                int securityGroupIdsListIndex = 1;
                for (String requestLaunchTemplateDataSecurityGroupIdsListValue : requestLaunchTemplateDataSecurityGroupIdsList) {
                    if (requestLaunchTemplateDataSecurityGroupIdsListValue != null) {
                        request.addParameter("LaunchTemplateData.SecurityGroupId." + securityGroupIdsListIndex, StringConversion.fromString((String)requestLaunchTemplateDataSecurityGroupIdsListValue));
                    }
                    ++securityGroupIdsListIndex;
                }
            }
            if (!(requestLaunchTemplateDataSecurityGroupsList = launchTemplateData.securityGroups()).isEmpty() || !(requestLaunchTemplateDataSecurityGroupsList instanceof SdkAutoConstructList)) {
                int securityGroupsListIndex = 1;
                for (String requestLaunchTemplateDataSecurityGroupsListValue : requestLaunchTemplateDataSecurityGroupsList) {
                    if (requestLaunchTemplateDataSecurityGroupsListValue != null) {
                        request.addParameter("LaunchTemplateData.SecurityGroup." + securityGroupsListIndex, StringConversion.fromString((String)requestLaunchTemplateDataSecurityGroupsListValue));
                    }
                    ++securityGroupsListIndex;
                }
            }
            if ((instanceMarketOptions = launchTemplateData.instanceMarketOptions()) != null) {
                LaunchTemplateSpotMarketOptionsRequest spotOptions;
                if (instanceMarketOptions.marketTypeAsString() != null) {
                    request.addParameter("LaunchTemplateData.InstanceMarketOptions.MarketType", StringConversion.fromString((String)instanceMarketOptions.marketTypeAsString()));
                }
                if ((spotOptions = instanceMarketOptions.spotOptions()) != null) {
                    if (spotOptions.maxPrice() != null) {
                        request.addParameter("LaunchTemplateData.InstanceMarketOptions.SpotOptions.MaxPrice", StringConversion.fromString((String)spotOptions.maxPrice()));
                    }
                    if (spotOptions.spotInstanceTypeAsString() != null) {
                        request.addParameter("LaunchTemplateData.InstanceMarketOptions.SpotOptions.SpotInstanceType", StringConversion.fromString((String)spotOptions.spotInstanceTypeAsString()));
                    }
                    if (spotOptions.blockDurationMinutes() != null) {
                        request.addParameter("LaunchTemplateData.InstanceMarketOptions.SpotOptions.BlockDurationMinutes", StringConversion.fromInteger((Integer)spotOptions.blockDurationMinutes()));
                    }
                    if (spotOptions.validUntil() != null) {
                        request.addParameter("LaunchTemplateData.InstanceMarketOptions.SpotOptions.ValidUntil", StringConversion.fromInstant((Instant)spotOptions.validUntil()));
                    }
                    if (spotOptions.instanceInterruptionBehaviorAsString() != null) {
                        request.addParameter("LaunchTemplateData.InstanceMarketOptions.SpotOptions.InstanceInterruptionBehavior", StringConversion.fromString((String)spotOptions.instanceInterruptionBehaviorAsString()));
                    }
                }
            }
            if ((creditSpecification = launchTemplateData.creditSpecification()) != null && creditSpecification.cpuCredits() != null) {
                request.addParameter("LaunchTemplateData.CreditSpecification.CpuCredits", StringConversion.fromString((String)creditSpecification.cpuCredits()));
            }
            if ((cpuOptions = launchTemplateData.cpuOptions()) != null) {
                if (cpuOptions.coreCount() != null) {
                    request.addParameter("LaunchTemplateData.CpuOptions.CoreCount", StringConversion.fromInteger((Integer)cpuOptions.coreCount()));
                }
                if (cpuOptions.threadsPerCore() != null) {
                    request.addParameter("LaunchTemplateData.CpuOptions.ThreadsPerCore", StringConversion.fromInteger((Integer)cpuOptions.threadsPerCore()));
                }
            }
        }
        return request;
    }
}

