/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesRequest;

public class AssignIpv6AddressesRequestMarshaller
implements Marshaller<Request<AssignIpv6AddressesRequest>, AssignIpv6AddressesRequest> {
    public Request<AssignIpv6AddressesRequest> marshall(AssignIpv6AddressesRequest assignIpv6AddressesRequest) {
        List<String> assignIpv6AddressesRequestIpv6AddressesList;
        if (assignIpv6AddressesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)assignIpv6AddressesRequest, "Ec2Client");
        request.addParameter("Action", "AssignIpv6Addresses");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (assignIpv6AddressesRequest.ipv6AddressCount() != null) {
            request.addParameter("Ipv6AddressCount", StringConversion.fromInteger((Integer)assignIpv6AddressesRequest.ipv6AddressCount()));
        }
        if (!(assignIpv6AddressesRequestIpv6AddressesList = assignIpv6AddressesRequest.ipv6Addresses()).isEmpty() || !(assignIpv6AddressesRequestIpv6AddressesList instanceof SdkAutoConstructList)) {
            int ipv6AddressesListIndex = 1;
            for (String assignIpv6AddressesRequestIpv6AddressesListValue : assignIpv6AddressesRequestIpv6AddressesList) {
                if (assignIpv6AddressesRequestIpv6AddressesListValue != null) {
                    request.addParameter("Ipv6Addresses." + ipv6AddressesListIndex, StringConversion.fromString((String)assignIpv6AddressesRequestIpv6AddressesListValue));
                }
                ++ipv6AddressesListIndex;
            }
        }
        if (assignIpv6AddressesRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringConversion.fromString((String)assignIpv6AddressesRequest.networkInterfaceId()));
        }
        return request;
    }
}

