/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.AllocateHostsRequest;

public class AllocateHostsRequestMarshaller
implements Marshaller<Request<AllocateHostsRequest>, AllocateHostsRequest> {
    public Request<AllocateHostsRequest> marshall(AllocateHostsRequest allocateHostsRequest) {
        if (allocateHostsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)allocateHostsRequest, "Ec2Client");
        request.addParameter("Action", "AllocateHosts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (allocateHostsRequest.autoPlacementAsString() != null) {
            request.addParameter("AutoPlacement", StringConversion.fromString((String)allocateHostsRequest.autoPlacementAsString()));
        }
        if (allocateHostsRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringConversion.fromString((String)allocateHostsRequest.availabilityZone()));
        }
        if (allocateHostsRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)allocateHostsRequest.clientToken()));
        }
        if (allocateHostsRequest.instanceType() != null) {
            request.addParameter("InstanceType", StringConversion.fromString((String)allocateHostsRequest.instanceType()));
        }
        if (allocateHostsRequest.quantity() != null) {
            request.addParameter("Quantity", StringConversion.fromInteger((Integer)allocateHostsRequest.quantity()));
        }
        return request;
    }
}

