/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InstanceIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartInstancesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, StartInstancesRequest> {
    private final List<String> instanceIds;
    private final String additionalInfo;

    private StartInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceIds = builder.instanceIds;
        this.additionalInfo = builder.additionalInfo;
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public String additionalInfo() {
        return this.additionalInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartInstancesRequest)) {
            return false;
        }
        StartInstancesRequest other = (StartInstancesRequest)((Object)obj);
        return Objects.equals(this.instanceIds(), other.instanceIds()) && Objects.equals(this.additionalInfo(), other.additionalInfo());
    }

    public String toString() {
        return ToString.builder((String)"StartInstancesRequest").add("InstanceIds", this.instanceIds()).add("AdditionalInfo", (Object)this.additionalInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceIds": {
                return Optional.ofNullable(clazz.cast(this.instanceIds()));
            }
            case "AdditionalInfo": {
                return Optional.ofNullable(clazz.cast(this.additionalInfo()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();
        private String additionalInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(StartInstancesRequest model) {
            super(model);
            this.instanceIds(model.instanceIds);
            this.additionalInfo(model.additionalInfo);
        }

        public final Collection<String> getInstanceIds() {
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartInstancesRequest build() {
            return new StartInstancesRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, StartInstancesRequest> {
        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder additionalInfo(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

