/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy;
import software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpotOptions
implements ToCopyableBuilder<Builder, SpotOptions> {
    private final String allocationStrategy;
    private final String instanceInterruptionBehavior;
    private final Integer instancePoolsToUseCount;

    private SpotOptions(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
        this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
        this.instancePoolsToUseCount = builder.instancePoolsToUseCount;
    }

    public SpotAllocationStrategy allocationStrategy() {
        return SpotAllocationStrategy.fromValue(this.allocationStrategy);
    }

    public String allocationStrategyAsString() {
        return this.allocationStrategy;
    }

    public SpotInstanceInterruptionBehavior instanceInterruptionBehavior() {
        return SpotInstanceInterruptionBehavior.fromValue(this.instanceInterruptionBehavior);
    }

    public String instanceInterruptionBehaviorAsString() {
        return this.instanceInterruptionBehavior;
    }

    public Integer instancePoolsToUseCount() {
        return this.instancePoolsToUseCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInterruptionBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePoolsToUseCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotOptions)) {
            return false;
        }
        SpotOptions other = (SpotOptions)obj;
        return Objects.equals(this.allocationStrategyAsString(), other.allocationStrategyAsString()) && Objects.equals(this.instanceInterruptionBehaviorAsString(), other.instanceInterruptionBehaviorAsString()) && Objects.equals(this.instancePoolsToUseCount(), other.instancePoolsToUseCount());
    }

    public String toString() {
        return ToString.builder((String)"SpotOptions").add("AllocationStrategy", (Object)this.allocationStrategyAsString()).add("InstanceInterruptionBehavior", (Object)this.instanceInterruptionBehaviorAsString()).add("InstancePoolsToUseCount", (Object)this.instancePoolsToUseCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategyAsString()));
            }
            case "InstanceInterruptionBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInterruptionBehaviorAsString()));
            }
            case "InstancePoolsToUseCount": {
                return Optional.ofNullable(clazz.cast(this.instancePoolsToUseCount()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationStrategy;
        private String instanceInterruptionBehavior;
        private Integer instancePoolsToUseCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotOptions model) {
            this.allocationStrategy(model.allocationStrategy);
            this.instanceInterruptionBehavior(model.instanceInterruptionBehavior);
            this.instancePoolsToUseCount(model.instancePoolsToUseCount);
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(SpotAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy.toString());
            return this;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        public final String getInstanceInterruptionBehavior() {
            return this.instanceInterruptionBehavior;
        }

        @Override
        public final Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        @Override
        public final Builder instanceInterruptionBehavior(SpotInstanceInterruptionBehavior instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior(instanceInterruptionBehavior.toString());
            return this;
        }

        public final void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
        }

        public final Integer getInstancePoolsToUseCount() {
            return this.instancePoolsToUseCount;
        }

        @Override
        public final Builder instancePoolsToUseCount(Integer instancePoolsToUseCount) {
            this.instancePoolsToUseCount = instancePoolsToUseCount;
            return this;
        }

        public final void setInstancePoolsToUseCount(Integer instancePoolsToUseCount) {
            this.instancePoolsToUseCount = instancePoolsToUseCount;
        }

        public SpotOptions build() {
            return new SpotOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotOptions> {
        public Builder allocationStrategy(String var1);

        public Builder allocationStrategy(SpotAllocationStrategy var1);

        public Builder instanceInterruptionBehavior(String var1);

        public Builder instanceInterruptionBehavior(SpotInstanceInterruptionBehavior var1);

        public Builder instancePoolsToUseCount(Integer var1);
    }
}

