/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SuccessfulInstanceCreditSpecificationItem;
import software.amazon.awssdk.services.ec2.model.SuccessfulInstanceCreditSpecificationSetCopier;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationItem;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstanceCreditSpecificationResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ModifyInstanceCreditSpecificationResponse> {
    private final List<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications;
    private final List<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications;

    private ModifyInstanceCreditSpecificationResponse(BuilderImpl builder) {
        super(builder);
        this.successfulInstanceCreditSpecifications = builder.successfulInstanceCreditSpecifications;
        this.unsuccessfulInstanceCreditSpecifications = builder.unsuccessfulInstanceCreditSpecifications;
    }

    public List<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications() {
        return this.successfulInstanceCreditSpecifications;
    }

    public List<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications() {
        return this.unsuccessfulInstanceCreditSpecifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.successfulInstanceCreditSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.unsuccessfulInstanceCreditSpecifications());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceCreditSpecificationResponse)) {
            return false;
        }
        ModifyInstanceCreditSpecificationResponse other = (ModifyInstanceCreditSpecificationResponse)((Object)obj);
        return Objects.equals(this.successfulInstanceCreditSpecifications(), other.successfulInstanceCreditSpecifications()) && Objects.equals(this.unsuccessfulInstanceCreditSpecifications(), other.unsuccessfulInstanceCreditSpecifications());
    }

    public String toString() {
        return ToString.builder((String)"ModifyInstanceCreditSpecificationResponse").add("SuccessfulInstanceCreditSpecifications", this.successfulInstanceCreditSpecifications()).add("UnsuccessfulInstanceCreditSpecifications", this.unsuccessfulInstanceCreditSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfulInstanceCreditSpecifications": {
                return Optional.ofNullable(clazz.cast(this.successfulInstanceCreditSpecifications()));
            }
            case "UnsuccessfulInstanceCreditSpecifications": {
                return Optional.ofNullable(clazz.cast(this.unsuccessfulInstanceCreditSpecifications()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications = DefaultSdkAutoConstructList.getInstance();
        private List<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceCreditSpecificationResponse model) {
            super(model);
            this.successfulInstanceCreditSpecifications(model.successfulInstanceCreditSpecifications);
            this.unsuccessfulInstanceCreditSpecifications(model.unsuccessfulInstanceCreditSpecifications);
        }

        public final Collection<SuccessfulInstanceCreditSpecificationItem.Builder> getSuccessfulInstanceCreditSpecifications() {
            return this.successfulInstanceCreditSpecifications != null ? (Collection)this.successfulInstanceCreditSpecifications.stream().map(SuccessfulInstanceCreditSpecificationItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successfulInstanceCreditSpecifications(Collection<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications) {
            this.successfulInstanceCreditSpecifications = SuccessfulInstanceCreditSpecificationSetCopier.copy(successfulInstanceCreditSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulInstanceCreditSpecifications(SuccessfulInstanceCreditSpecificationItem ... successfulInstanceCreditSpecifications) {
            this.successfulInstanceCreditSpecifications(Arrays.asList(successfulInstanceCreditSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulInstanceCreditSpecifications(Consumer<SuccessfulInstanceCreditSpecificationItem.Builder> ... successfulInstanceCreditSpecifications) {
            this.successfulInstanceCreditSpecifications(Stream.of(successfulInstanceCreditSpecifications).map(c -> (SuccessfulInstanceCreditSpecificationItem)((SuccessfulInstanceCreditSpecificationItem.Builder)SuccessfulInstanceCreditSpecificationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessfulInstanceCreditSpecifications(Collection<SuccessfulInstanceCreditSpecificationItem.BuilderImpl> successfulInstanceCreditSpecifications) {
            this.successfulInstanceCreditSpecifications = SuccessfulInstanceCreditSpecificationSetCopier.copyFromBuilder(successfulInstanceCreditSpecifications);
        }

        public final Collection<UnsuccessfulInstanceCreditSpecificationItem.Builder> getUnsuccessfulInstanceCreditSpecifications() {
            return this.unsuccessfulInstanceCreditSpecifications != null ? (Collection)this.unsuccessfulInstanceCreditSpecifications.stream().map(UnsuccessfulInstanceCreditSpecificationItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unsuccessfulInstanceCreditSpecifications(Collection<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications) {
            this.unsuccessfulInstanceCreditSpecifications = UnsuccessfulInstanceCreditSpecificationSetCopier.copy(unsuccessfulInstanceCreditSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulInstanceCreditSpecifications(UnsuccessfulInstanceCreditSpecificationItem ... unsuccessfulInstanceCreditSpecifications) {
            this.unsuccessfulInstanceCreditSpecifications(Arrays.asList(unsuccessfulInstanceCreditSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulInstanceCreditSpecifications(Consumer<UnsuccessfulInstanceCreditSpecificationItem.Builder> ... unsuccessfulInstanceCreditSpecifications) {
            this.unsuccessfulInstanceCreditSpecifications(Stream.of(unsuccessfulInstanceCreditSpecifications).map(c -> (UnsuccessfulInstanceCreditSpecificationItem)((UnsuccessfulInstanceCreditSpecificationItem.Builder)UnsuccessfulInstanceCreditSpecificationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnsuccessfulInstanceCreditSpecifications(Collection<UnsuccessfulInstanceCreditSpecificationItem.BuilderImpl> unsuccessfulInstanceCreditSpecifications) {
            this.unsuccessfulInstanceCreditSpecifications = UnsuccessfulInstanceCreditSpecificationSetCopier.copyFromBuilder(unsuccessfulInstanceCreditSpecifications);
        }

        @Override
        public ModifyInstanceCreditSpecificationResponse build() {
            return new ModifyInstanceCreditSpecificationResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, ModifyInstanceCreditSpecificationResponse> {
        public Builder successfulInstanceCreditSpecifications(Collection<SuccessfulInstanceCreditSpecificationItem> var1);

        public Builder successfulInstanceCreditSpecifications(SuccessfulInstanceCreditSpecificationItem ... var1);

        public Builder successfulInstanceCreditSpecifications(Consumer<SuccessfulInstanceCreditSpecificationItem.Builder> ... var1);

        public Builder unsuccessfulInstanceCreditSpecifications(Collection<UnsuccessfulInstanceCreditSpecificationItem> var1);

        public Builder unsuccessfulInstanceCreditSpecifications(UnsuccessfulInstanceCreditSpecificationItem ... var1);

        public Builder unsuccessfulInstanceCreditSpecifications(Consumer<UnsuccessfulInstanceCreditSpecificationItem.Builder> ... var1);
    }
}

