/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.PermissionGroup;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadPermission
implements ToCopyableBuilder<Builder, LoadPermission> {
    private final String userId;
    private final String group;

    private LoadPermission(BuilderImpl builder) {
        this.userId = builder.userId;
        this.group = builder.group;
    }

    public String userId() {
        return this.userId;
    }

    public PermissionGroup group() {
        return PermissionGroup.fromValue(this.group);
    }

    public String groupAsString() {
        return this.group;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadPermission)) {
            return false;
        }
        LoadPermission other = (LoadPermission)obj;
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.groupAsString(), other.groupAsString());
    }

    public String toString() {
        return ToString.builder((String)"LoadPermission").add("UserId", (Object)this.userId()).add("Group", (Object)this.groupAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.groupAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userId;
        private String group;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadPermission model) {
            this.userId(model.userId);
            this.group(model.group);
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public final Builder group(PermissionGroup group) {
            this.group(group.toString());
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public LoadPermission build() {
            return new LoadPermission(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadPermission> {
        public Builder userId(String var1);

        public Builder group(String var1);

        public Builder group(PermissionGroup var1);
    }
}

