/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplate
implements ToCopyableBuilder<Builder, LaunchTemplate> {
    private final String launchTemplateId;
    private final String launchTemplateName;
    private final Instant createTime;
    private final String createdBy;
    private final Long defaultVersionNumber;
    private final Long latestVersionNumber;
    private final List<Tag> tags;

    private LaunchTemplate(BuilderImpl builder) {
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.createTime = builder.createTime;
        this.createdBy = builder.createdBy;
        this.defaultVersionNumber = builder.defaultVersionNumber;
        this.latestVersionNumber = builder.latestVersionNumber;
        this.tags = builder.tags;
    }

    public String launchTemplateId() {
        return this.launchTemplateId;
    }

    public String launchTemplateName() {
        return this.launchTemplateName;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public String createdBy() {
        return this.createdBy;
    }

    public Long defaultVersionNumber() {
        return this.defaultVersionNumber;
    }

    public Long latestVersionNumber() {
        return this.latestVersionNumber;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplate)) {
            return false;
        }
        LaunchTemplate other = (LaunchTemplate)obj;
        return Objects.equals(this.launchTemplateId(), other.launchTemplateId()) && Objects.equals(this.launchTemplateName(), other.launchTemplateName()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.defaultVersionNumber(), other.defaultVersionNumber()) && Objects.equals(this.latestVersionNumber(), other.latestVersionNumber()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"LaunchTemplate").add("LaunchTemplateId", (Object)this.launchTemplateId()).add("LaunchTemplateName", (Object)this.launchTemplateName()).add("CreateTime", (Object)this.createTime()).add("CreatedBy", (Object)this.createdBy()).add("DefaultVersionNumber", (Object)this.defaultVersionNumber()).add("LatestVersionNumber", (Object)this.latestVersionNumber()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateId": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateId()));
            }
            case "LaunchTemplateName": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateName()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "DefaultVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.defaultVersionNumber()));
            }
            case "LatestVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.latestVersionNumber()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String launchTemplateId;
        private String launchTemplateName;
        private Instant createTime;
        private String createdBy;
        private Long defaultVersionNumber;
        private Long latestVersionNumber;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplate model) {
            this.launchTemplateId(model.launchTemplateId);
            this.launchTemplateName(model.launchTemplateName);
            this.createTime(model.createTime);
            this.createdBy(model.createdBy);
            this.defaultVersionNumber(model.defaultVersionNumber);
            this.latestVersionNumber(model.latestVersionNumber);
            this.tags(model.tags);
        }

        public final String getLaunchTemplateId() {
            return this.launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        public final String getLaunchTemplateName() {
            return this.launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final Long getDefaultVersionNumber() {
            return this.defaultVersionNumber;
        }

        @Override
        public final Builder defaultVersionNumber(Long defaultVersionNumber) {
            this.defaultVersionNumber = defaultVersionNumber;
            return this;
        }

        public final void setDefaultVersionNumber(Long defaultVersionNumber) {
            this.defaultVersionNumber = defaultVersionNumber;
        }

        public final Long getLatestVersionNumber() {
            return this.latestVersionNumber;
        }

        @Override
        public final Builder latestVersionNumber(Long latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
            return this;
        }

        public final void setLatestVersionNumber(Long latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public LaunchTemplate build() {
            return new LaunchTemplate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LaunchTemplate> {
        public Builder launchTemplateId(String var1);

        public Builder launchTemplateName(String var1);

        public Builder createTime(Instant var1);

        public Builder createdBy(String var1);

        public Builder defaultVersionNumber(Long var1);

        public Builder latestVersionNumber(Long var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

