/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchPermission;
import software.amazon.awssdk.services.ec2.model.LaunchPermissionListCopier;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageAttribute
implements ToCopyableBuilder<Builder, ImageAttribute> {
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final String imageId;
    private final List<LaunchPermission> launchPermissions;
    private final List<ProductCode> productCodes;
    private final String description;
    private final String kernelId;
    private final String ramdiskId;
    private final String sriovNetSupport;

    private ImageAttribute(BuilderImpl builder) {
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.imageId = builder.imageId;
        this.launchPermissions = builder.launchPermissions;
        this.productCodes = builder.productCodes;
        this.description = builder.description;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.sriovNetSupport = builder.sriovNetSupport;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public String imageId() {
        return this.imageId;
    }

    public List<LaunchPermission> launchPermissions() {
        return this.launchPermissions;
    }

    public List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public String description() {
        return this.description;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public String sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sriovNetSupport());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageAttribute)) {
            return false;
        }
        ImageAttribute other = (ImageAttribute)obj;
        return Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.launchPermissions(), other.launchPermissions()) && Objects.equals(this.productCodes(), other.productCodes()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && Objects.equals(this.sriovNetSupport(), other.sriovNetSupport());
    }

    public String toString() {
        return ToString.builder((String)"ImageAttribute").add("BlockDeviceMappings", this.blockDeviceMappings()).add("ImageId", (Object)this.imageId()).add("LaunchPermissions", this.launchPermissions()).add("ProductCodes", this.productCodes()).add("Description", (Object)this.description()).add("KernelId", (Object)this.kernelId()).add("RamdiskId", (Object)this.ramdiskId()).add("SriovNetSupport", (Object)this.sriovNetSupport()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "LaunchPermissions": {
                return Optional.ofNullable(clazz.cast(this.launchPermissions()));
            }
            case "ProductCodes": {
                return Optional.ofNullable(clazz.cast(this.productCodes()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "RamdiskId": {
                return Optional.ofNullable(clazz.cast(this.ramdiskId()));
            }
            case "SriovNetSupport": {
                return Optional.ofNullable(clazz.cast(this.sriovNetSupport()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private String imageId;
        private List<LaunchPermission> launchPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String kernelId;
        private String ramdiskId;
        private String sriovNetSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageAttribute model) {
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.imageId(model.imageId);
            this.launchPermissions(model.launchPermissions);
            this.productCodes(model.productCodes);
            this.description(model.description);
            this.kernelId(model.kernelId);
            this.ramdiskId(model.ramdiskId);
            this.sriovNetSupport(model.sriovNetSupport);
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (BlockDeviceMapping)((BlockDeviceMapping.Builder)BlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final Collection<LaunchPermission.Builder> getLaunchPermissions() {
            return this.launchPermissions != null ? (Collection)this.launchPermissions.stream().map(LaunchPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchPermissions(Collection<LaunchPermission> launchPermissions) {
            this.launchPermissions = LaunchPermissionListCopier.copy(launchPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPermissions(LaunchPermission ... launchPermissions) {
            this.launchPermissions(Arrays.asList(launchPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPermissions(Consumer<LaunchPermission.Builder> ... launchPermissions) {
            this.launchPermissions(Stream.of(launchPermissions).map(c -> (LaunchPermission)((LaunchPermission.Builder)LaunchPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchPermissions(Collection<LaunchPermission.BuilderImpl> launchPermissions) {
            this.launchPermissions = LaunchPermissionListCopier.copyFromBuilder(launchPermissions);
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return this.productCodes != null ? (Collection)this.productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder> ... productCodes) {
            this.productCodes(Stream.of(productCodes).map(c -> (ProductCode)((ProductCode.Builder)ProductCode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getSriovNetSupport() {
            return this.sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public ImageAttribute build() {
            return new ImageAttribute(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImageAttribute> {
        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... var1);

        public Builder imageId(String var1);

        public Builder launchPermissions(Collection<LaunchPermission> var1);

        public Builder launchPermissions(LaunchPermission ... var1);

        public Builder launchPermissions(Consumer<LaunchPermission.Builder> ... var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder productCodes(Consumer<ProductCode.Builder> ... var1);

        public Builder description(String var1);

        public Builder kernelId(String var1);

        public Builder ramdiskId(String var1);

        public Builder sriovNetSupport(String var1);
    }
}

