/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfile;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IamInstanceProfileAssociation
implements ToCopyableBuilder<Builder, IamInstanceProfileAssociation> {
    private final String associationId;
    private final String instanceId;
    private final IamInstanceProfile iamInstanceProfile;
    private final String state;
    private final Instant timestamp;

    private IamInstanceProfileAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.instanceId = builder.instanceId;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.state = builder.state;
        this.timestamp = builder.timestamp;
    }

    public String associationId() {
        return this.associationId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public IamInstanceProfile iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public IamInstanceProfileAssociationState state() {
        return IamInstanceProfileAssociationState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamInstanceProfileAssociation)) {
            return false;
        }
        IamInstanceProfileAssociation other = (IamInstanceProfileAssociation)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public String toString() {
        return ToString.builder((String)"IamInstanceProfileAssociation").add("AssociationId", (Object)this.associationId()).add("InstanceId", (Object)this.instanceId()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("State", (Object)this.stateAsString()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String instanceId;
        private IamInstanceProfile iamInstanceProfile;
        private String state;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(IamInstanceProfileAssociation model) {
            this.associationId(model.associationId);
            this.instanceId(model.instanceId);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.state(model.state);
            this.timestamp(model.timestamp);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final IamInstanceProfile.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfile.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IamInstanceProfileAssociationState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public IamInstanceProfileAssociation build() {
            return new IamInstanceProfileAssociation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IamInstanceProfileAssociation> {
        public Builder associationId(String var1);

        public Builder instanceId(String var1);

        public Builder iamInstanceProfile(IamInstanceProfile var1);

        default public Builder iamInstanceProfile(Consumer<IamInstanceProfile.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((IamInstanceProfile)((IamInstanceProfile.Builder)IamInstanceProfile.builder().applyMutation(iamInstanceProfile)).build());
        }

        public Builder state(String var1);

        public Builder state(IamInstanceProfileAssociationState var1);

        public Builder timestamp(Instant var1);
    }
}

