/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConsoleOutputRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, GetConsoleOutputRequest> {
    private final String instanceId;
    private final Boolean latest;

    private GetConsoleOutputRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.latest = builder.latest;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Boolean latest() {
        return this.latest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.latest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConsoleOutputRequest)) {
            return false;
        }
        GetConsoleOutputRequest other = (GetConsoleOutputRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.latest(), other.latest());
    }

    public String toString() {
        return ToString.builder((String)"GetConsoleOutputRequest").add("InstanceId", (Object)this.instanceId()).add("Latest", (Object)this.latest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Latest": {
                return Optional.ofNullable(clazz.cast(this.latest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String instanceId;
        private Boolean latest;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConsoleOutputRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.latest(model.latest);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Boolean getLatest() {
            return this.latest;
        }

        @Override
        public final Builder latest(Boolean latest) {
            this.latest = latest;
            return this;
        }

        public final void setLatest(Boolean latest) {
            this.latest = latest;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConsoleOutputRequest build() {
            return new GetConsoleOutputRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, GetConsoleOutputRequest> {
        public Builder instanceId(String var1);

        public Builder latest(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

