/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.DiskImageFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiskImageDetail
implements ToCopyableBuilder<Builder, DiskImageDetail> {
    private final Long bytes;
    private final String format;
    private final String importManifestUrl;

    private DiskImageDetail(BuilderImpl builder) {
        this.bytes = builder.bytes;
        this.format = builder.format;
        this.importManifestUrl = builder.importManifestUrl;
    }

    public Long bytes() {
        return this.bytes;
    }

    public DiskImageFormat format() {
        return DiskImageFormat.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public String importManifestUrl() {
        return this.importManifestUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.importManifestUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskImageDetail)) {
            return false;
        }
        DiskImageDetail other = (DiskImageDetail)obj;
        return Objects.equals(this.bytes(), other.bytes()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.importManifestUrl(), other.importManifestUrl());
    }

    public String toString() {
        return ToString.builder((String)"DiskImageDetail").add("Bytes", (Object)this.bytes()).add("Format", (Object)this.formatAsString()).add("ImportManifestUrl", (Object)this.importManifestUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bytes": {
                return Optional.ofNullable(clazz.cast(this.bytes()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "ImportManifestUrl": {
                return Optional.ofNullable(clazz.cast(this.importManifestUrl()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Long bytes;
        private String format;
        private String importManifestUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskImageDetail model) {
            this.bytes(model.bytes);
            this.format(model.format);
            this.importManifestUrl(model.importManifestUrl);
        }

        public final Long getBytes() {
            return this.bytes;
        }

        @Override
        public final Builder bytes(Long bytes) {
            this.bytes = bytes;
            return this;
        }

        public final void setBytes(Long bytes) {
            this.bytes = bytes;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(DiskImageFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getImportManifestUrl() {
            return this.importManifestUrl;
        }

        @Override
        public final Builder importManifestUrl(String importManifestUrl) {
            this.importManifestUrl = importManifestUrl;
            return this;
        }

        public final void setImportManifestUrl(String importManifestUrl) {
            this.importManifestUrl = importManifestUrl;
        }

        public DiskImageDetail build() {
            return new DiskImageDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DiskImageDetail> {
        public Builder bytes(Long var1);

        public Builder format(String var1);

        public Builder format(DiskImageFormat var1);

        public Builder importManifestUrl(String var1);
    }
}

