/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VolumeModification;
import software.amazon.awssdk.services.ec2.model.VolumeModificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVolumesModificationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVolumesModificationsResponse> {
    private final List<VolumeModification> volumesModifications;
    private final String nextToken;

    private DescribeVolumesModificationsResponse(BuilderImpl builder) {
        super(builder);
        this.volumesModifications = builder.volumesModifications;
        this.nextToken = builder.nextToken;
    }

    public List<VolumeModification> volumesModifications() {
        return this.volumesModifications;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumesModifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesModificationsResponse)) {
            return false;
        }
        DescribeVolumesModificationsResponse other = (DescribeVolumesModificationsResponse)((Object)obj);
        return Objects.equals(this.volumesModifications(), other.volumesModifications()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVolumesModificationsResponse").add("VolumesModifications", this.volumesModifications()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumesModifications": {
                return Optional.ofNullable(clazz.cast(this.volumesModifications()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VolumeModification> volumesModifications = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesModificationsResponse model) {
            super(model);
            this.volumesModifications(model.volumesModifications);
            this.nextToken(model.nextToken);
        }

        public final Collection<VolumeModification.Builder> getVolumesModifications() {
            return this.volumesModifications != null ? (Collection)this.volumesModifications.stream().map(VolumeModification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumesModifications(Collection<VolumeModification> volumesModifications) {
            this.volumesModifications = VolumeModificationListCopier.copy(volumesModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumesModifications(VolumeModification ... volumesModifications) {
            this.volumesModifications(Arrays.asList(volumesModifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumesModifications(Consumer<VolumeModification.Builder> ... volumesModifications) {
            this.volumesModifications(Stream.of(volumesModifications).map(c -> (VolumeModification)((VolumeModification.Builder)VolumeModification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVolumesModifications(Collection<VolumeModification.BuilderImpl> volumesModifications) {
            this.volumesModifications = VolumeModificationListCopier.copyFromBuilder(volumesModifications);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVolumesModificationsResponse build() {
            return new DescribeVolumesModificationsResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeVolumesModificationsResponse> {
        public Builder volumesModifications(Collection<VolumeModification> var1);

        public Builder volumesModifications(VolumeModification ... var1);

        public Builder volumesModifications(Consumer<VolumeModification.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

