/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.GroupIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSecurityGroupReferencesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeSecurityGroupReferencesRequest> {
    private final List<String> groupId;

    private DescribeSecurityGroupReferencesRequest(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
    }

    public List<String> groupId() {
        return this.groupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupReferencesRequest)) {
            return false;
        }
        DescribeSecurityGroupReferencesRequest other = (DescribeSecurityGroupReferencesRequest)((Object)obj);
        return Objects.equals(this.groupId(), other.groupId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSecurityGroupReferencesRequest").add("GroupId", this.groupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> groupId = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupReferencesRequest model) {
            super(model);
            this.groupId(model.groupId);
        }

        public final Collection<String> getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(Collection<String> groupId) {
            this.groupId = GroupIdsCopier.copy(groupId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupId(String ... groupId) {
            this.groupId(Arrays.asList(groupId));
            return this;
        }

        public final void setGroupId(Collection<String> groupId) {
            this.groupId = GroupIdsCopier.copy(groupId);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSecurityGroupReferencesRequest build() {
            return new DescribeSecurityGroupReferencesRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, DescribeSecurityGroupReferencesRequest> {
        public Builder groupId(Collection<String> var1);

        public Builder groupId(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

