/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateNameStringListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLaunchTemplatesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeLaunchTemplatesRequest> {
    private final List<String> launchTemplateIds;
    private final List<String> launchTemplateNames;
    private final List<Filter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeLaunchTemplatesRequest(BuilderImpl builder) {
        super(builder);
        this.launchTemplateIds = builder.launchTemplateIds;
        this.launchTemplateNames = builder.launchTemplateNames;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public List<String> launchTemplateIds() {
        return this.launchTemplateIds;
    }

    public List<String> launchTemplateNames() {
        return this.launchTemplateNames;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLaunchTemplatesRequest)) {
            return false;
        }
        DescribeLaunchTemplatesRequest other = (DescribeLaunchTemplatesRequest)((Object)obj);
        return Objects.equals(this.launchTemplateIds(), other.launchTemplateIds()) && Objects.equals(this.launchTemplateNames(), other.launchTemplateNames()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLaunchTemplatesRequest").add("LaunchTemplateIds", this.launchTemplateIds()).add("LaunchTemplateNames", this.launchTemplateNames()).add("Filters", this.filters()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateIds": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateIds()));
            }
            case "LaunchTemplateNames": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateNames()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> launchTemplateIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> launchTemplateNames = DefaultSdkAutoConstructList.getInstance();
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLaunchTemplatesRequest model) {
            super(model);
            this.launchTemplateIds(model.launchTemplateIds);
            this.launchTemplateNames(model.launchTemplateNames);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getLaunchTemplateIds() {
            return this.launchTemplateIds;
        }

        @Override
        public final Builder launchTemplateIds(Collection<String> launchTemplateIds) {
            this.launchTemplateIds = ValueStringListCopier.copy(launchTemplateIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateIds(String ... launchTemplateIds) {
            this.launchTemplateIds(Arrays.asList(launchTemplateIds));
            return this;
        }

        public final void setLaunchTemplateIds(Collection<String> launchTemplateIds) {
            this.launchTemplateIds = ValueStringListCopier.copy(launchTemplateIds);
        }

        public final Collection<String> getLaunchTemplateNames() {
            return this.launchTemplateNames;
        }

        @Override
        public final Builder launchTemplateNames(Collection<String> launchTemplateNames) {
            this.launchTemplateNames = LaunchTemplateNameStringListCopier.copy(launchTemplateNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateNames(String ... launchTemplateNames) {
            this.launchTemplateNames(Arrays.asList(launchTemplateNames));
            return this;
        }

        public final void setLaunchTemplateNames(Collection<String> launchTemplateNames) {
            this.launchTemplateNames = LaunchTemplateNameStringListCopier.copy(launchTemplateNames);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLaunchTemplatesRequest build() {
            return new DescribeLaunchTemplatesRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, DescribeLaunchTemplatesRequest> {
        public Builder launchTemplateIds(Collection<String> var1);

        public Builder launchTemplateIds(String ... var1);

        public Builder launchTemplateNames(Collection<String> var1);

        public Builder launchTemplateNames(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

