/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IdFormat;
import software.amazon.awssdk.services.ec2.model.IdFormatListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAggregateIdFormatResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeAggregateIdFormatResponse> {
    private final Boolean useLongIdsAggregated;
    private final List<IdFormat> statuses;

    private DescribeAggregateIdFormatResponse(BuilderImpl builder) {
        super(builder);
        this.useLongIdsAggregated = builder.useLongIdsAggregated;
        this.statuses = builder.statuses;
    }

    public Boolean useLongIdsAggregated() {
        return this.useLongIdsAggregated;
    }

    public List<IdFormat> statuses() {
        return this.statuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.useLongIdsAggregated());
        hashCode = 31 * hashCode + Objects.hashCode(this.statuses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAggregateIdFormatResponse)) {
            return false;
        }
        DescribeAggregateIdFormatResponse other = (DescribeAggregateIdFormatResponse)((Object)obj);
        return Objects.equals(this.useLongIdsAggregated(), other.useLongIdsAggregated()) && Objects.equals(this.statuses(), other.statuses());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAggregateIdFormatResponse").add("UseLongIdsAggregated", (Object)this.useLongIdsAggregated()).add("Statuses", this.statuses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UseLongIdsAggregated": {
                return Optional.ofNullable(clazz.cast(this.useLongIdsAggregated()));
            }
            case "Statuses": {
                return Optional.ofNullable(clazz.cast(this.statuses()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private Boolean useLongIdsAggregated;
        private List<IdFormat> statuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAggregateIdFormatResponse model) {
            super(model);
            this.useLongIdsAggregated(model.useLongIdsAggregated);
            this.statuses(model.statuses);
        }

        public final Boolean getUseLongIdsAggregated() {
            return this.useLongIdsAggregated;
        }

        @Override
        public final Builder useLongIdsAggregated(Boolean useLongIdsAggregated) {
            this.useLongIdsAggregated = useLongIdsAggregated;
            return this;
        }

        public final void setUseLongIdsAggregated(Boolean useLongIdsAggregated) {
            this.useLongIdsAggregated = useLongIdsAggregated;
        }

        public final Collection<IdFormat.Builder> getStatuses() {
            return this.statuses != null ? (Collection)this.statuses.stream().map(IdFormat::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statuses(Collection<IdFormat> statuses) {
            this.statuses = IdFormatListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(IdFormat ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(Consumer<IdFormat.Builder> ... statuses) {
            this.statuses(Stream.of(statuses).map(c -> (IdFormat)((IdFormat.Builder)IdFormat.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatuses(Collection<IdFormat.BuilderImpl> statuses) {
            this.statuses = IdFormatListCopier.copyFromBuilder(statuses);
        }

        @Override
        public DescribeAggregateIdFormatResponse build() {
            return new DescribeAggregateIdFormatResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeAggregateIdFormatResponse> {
        public Builder useLongIdsAggregated(Boolean var1);

        public Builder statuses(Collection<IdFormat> var1);

        public Builder statuses(IdFormat ... var1);

        public Builder statuses(Consumer<IdFormat.Builder> ... var1);
    }
}

