/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.FleetIdSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFleetsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteFleetsRequest> {
    private final List<String> fleetIds;
    private final Boolean terminateInstances;

    private DeleteFleetsRequest(BuilderImpl builder) {
        super(builder);
        this.fleetIds = builder.fleetIds;
        this.terminateInstances = builder.terminateInstances;
    }

    public List<String> fleetIds() {
        return this.fleetIds;
    }

    public Boolean terminateInstances() {
        return this.terminateInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateInstances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFleetsRequest)) {
            return false;
        }
        DeleteFleetsRequest other = (DeleteFleetsRequest)((Object)obj);
        return Objects.equals(this.fleetIds(), other.fleetIds()) && Objects.equals(this.terminateInstances(), other.terminateInstances());
    }

    public String toString() {
        return ToString.builder((String)"DeleteFleetsRequest").add("FleetIds", this.fleetIds()).add("TerminateInstances", (Object)this.terminateInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetIds": {
                return Optional.ofNullable(clazz.cast(this.fleetIds()));
            }
            case "TerminateInstances": {
                return Optional.ofNullable(clazz.cast(this.terminateInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> fleetIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean terminateInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFleetsRequest model) {
            super(model);
            this.fleetIds(model.fleetIds);
            this.terminateInstances(model.terminateInstances);
        }

        public final Collection<String> getFleetIds() {
            return this.fleetIds;
        }

        @Override
        public final Builder fleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdSetCopier.copy(fleetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetIds(String ... fleetIds) {
            this.fleetIds(Arrays.asList(fleetIds));
            return this;
        }

        public final void setFleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdSetCopier.copy(fleetIds);
        }

        public final Boolean getTerminateInstances() {
            return this.terminateInstances;
        }

        @Override
        public final Builder terminateInstances(Boolean terminateInstances) {
            this.terminateInstances = terminateInstances;
            return this;
        }

        public final void setTerminateInstances(Boolean terminateInstances) {
            this.terminateInstances = terminateInstances;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFleetsRequest build() {
            return new DeleteFleetsRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, DeleteFleetsRequest> {
        public Builder fleetIds(Collection<String> var1);

        public Builder fleetIds(String ... var1);

        public Builder terminateInstances(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

