/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ServiceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcEndpointServiceConfigurationResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateVpcEndpointServiceConfigurationResponse> {
    private final ServiceConfiguration serviceConfiguration;
    private final String clientToken;

    private CreateVpcEndpointServiceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.serviceConfiguration = builder.serviceConfiguration;
        this.clientToken = builder.clientToken;
    }

    public ServiceConfiguration serviceConfiguration() {
        return this.serviceConfiguration;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointServiceConfigurationResponse)) {
            return false;
        }
        CreateVpcEndpointServiceConfigurationResponse other = (CreateVpcEndpointServiceConfigurationResponse)((Object)obj);
        return Objects.equals(this.serviceConfiguration(), other.serviceConfiguration()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateVpcEndpointServiceConfigurationResponse").add("ServiceConfiguration", (Object)this.serviceConfiguration()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serviceConfiguration()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private ServiceConfiguration serviceConfiguration;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointServiceConfigurationResponse model) {
            super(model);
            this.serviceConfiguration(model.serviceConfiguration);
            this.clientToken(model.clientToken);
        }

        public final ServiceConfiguration.Builder getServiceConfiguration() {
            return this.serviceConfiguration != null ? this.serviceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder serviceConfiguration(ServiceConfiguration serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration;
            return this;
        }

        public final void setServiceConfiguration(ServiceConfiguration.BuilderImpl serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration != null ? serviceConfiguration.build() : null;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreateVpcEndpointServiceConfigurationResponse build() {
            return new CreateVpcEndpointServiceConfigurationResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, CreateVpcEndpointServiceConfigurationResponse> {
        public Builder serviceConfiguration(ServiceConfiguration var1);

        default public Builder serviceConfiguration(Consumer<ServiceConfiguration.Builder> serviceConfiguration) {
            return this.serviceConfiguration((ServiceConfiguration)((ServiceConfiguration.Builder)ServiceConfiguration.builder().applyMutation(serviceConfiguration)).build());
        }

        public Builder clientToken(String var1);
    }
}

