/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.EbsBlockDevice;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecification;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagSpecification;

public class RunInstancesRequestMarshaller
implements Marshaller<Request<RunInstancesRequest>, RunInstancesRequest> {
    /*
     * Could not resolve type clashes
     */
    public Request<RunInstancesRequest> marshall(RunInstancesRequest runInstancesRequest) {
        List<TagSpecification> runInstancesRequestTagSpecificationsList;
        List<ElasticGpuSpecification> runInstancesRequestElasticGpuSpecificationList;
        List<InstanceNetworkInterfaceSpecification> runInstancesRequestNetworkInterfacesList;
        IamInstanceProfileSpecification iamInstanceProfile;
        List<String> runInstancesRequestSecurityGroupsList;
        List<String> runInstancesRequestSecurityGroupIdsList;
        Placement placement;
        List<InstanceIpv6Address> runInstancesRequestIpv6AddressesList;
        if (runInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)runInstancesRequest, "Ec2Client");
        request.addParameter("Action", "RunInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<BlockDeviceMapping> runInstancesRequestBlockDeviceMappingsList = runInstancesRequest.blockDeviceMappings();
        if (!runInstancesRequestBlockDeviceMappingsList.isEmpty() || !(runInstancesRequestBlockDeviceMappingsList instanceof SdkAutoConstructList)) {
            int blockDeviceMappingsListIndex = 1;
            for (Object runInstancesRequestBlockDeviceMappingsListValue : runInstancesRequestBlockDeviceMappingsList) {
                EbsBlockDevice ebs;
                if (((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).deviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringConversion.fromString((String)((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).deviceName()));
                }
                if (((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).virtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringConversion.fromString((String)((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).virtualName()));
                }
                if ((ebs = ((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).ebs()) != null) {
                    if (ebs.encrypted() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringConversion.fromBoolean((Boolean)ebs.encrypted()));
                    }
                    if (ebs.deleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringConversion.fromBoolean((Boolean)ebs.deleteOnTermination()));
                    }
                    if (ebs.iops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringConversion.fromInteger((Integer)ebs.iops()));
                    }
                    if (ebs.snapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringConversion.fromString((String)ebs.snapshotId()));
                    }
                    if (ebs.volumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringConversion.fromInteger((Integer)ebs.volumeSize()));
                    }
                    if (ebs.volumeTypeAsString() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringConversion.fromString((String)ebs.volumeTypeAsString()));
                    }
                }
                if (((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).noDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringConversion.fromString((String)((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).noDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (runInstancesRequest.imageId() != null) {
            request.addParameter("ImageId", StringConversion.fromString((String)runInstancesRequest.imageId()));
        }
        if (runInstancesRequest.instanceTypeAsString() != null) {
            request.addParameter("InstanceType", StringConversion.fromString((String)runInstancesRequest.instanceTypeAsString()));
        }
        if (runInstancesRequest.ipv6AddressCount() != null) {
            request.addParameter("Ipv6AddressCount", StringConversion.fromInteger((Integer)runInstancesRequest.ipv6AddressCount()));
        }
        if (!(runInstancesRequestIpv6AddressesList = runInstancesRequest.ipv6Addresses()).isEmpty() || !(runInstancesRequestIpv6AddressesList instanceof SdkAutoConstructList)) {
            int ipv6AddressesListIndex = 1;
            for (InstanceIpv6Address runInstancesRequestIpv6AddressesListValue : runInstancesRequestIpv6AddressesList) {
                if (runInstancesRequestIpv6AddressesListValue.ipv6Address() != null) {
                    request.addParameter("Ipv6Address." + ipv6AddressesListIndex + ".Ipv6Address", StringConversion.fromString((String)runInstancesRequestIpv6AddressesListValue.ipv6Address()));
                }
                ++ipv6AddressesListIndex;
            }
        }
        if (runInstancesRequest.kernelId() != null) {
            request.addParameter("KernelId", StringConversion.fromString((String)runInstancesRequest.kernelId()));
        }
        if (runInstancesRequest.keyName() != null) {
            request.addParameter("KeyName", StringConversion.fromString((String)runInstancesRequest.keyName()));
        }
        if (runInstancesRequest.maxCount() != null) {
            request.addParameter("MaxCount", StringConversion.fromInteger((Integer)runInstancesRequest.maxCount()));
        }
        if (runInstancesRequest.minCount() != null) {
            request.addParameter("MinCount", StringConversion.fromInteger((Integer)runInstancesRequest.minCount()));
        }
        if (runInstancesRequest.monitoring() != null) {
            request.addParameter("Monitoring.Enabled", StringConversion.fromBoolean((Boolean)runInstancesRequest.monitoring()));
        }
        if ((placement = runInstancesRequest.placement()) != null) {
            if (placement.availabilityZone() != null) {
                request.addParameter("Placement.AvailabilityZone", StringConversion.fromString((String)placement.availabilityZone()));
            }
            if (placement.affinity() != null) {
                request.addParameter("Placement.Affinity", StringConversion.fromString((String)placement.affinity()));
            }
            if (placement.groupName() != null) {
                request.addParameter("Placement.GroupName", StringConversion.fromString((String)placement.groupName()));
            }
            if (placement.hostId() != null) {
                request.addParameter("Placement.HostId", StringConversion.fromString((String)placement.hostId()));
            }
            if (placement.tenancyAsString() != null) {
                request.addParameter("Placement.Tenancy", StringConversion.fromString((String)placement.tenancyAsString()));
            }
            if (placement.spreadDomain() != null) {
                request.addParameter("Placement.SpreadDomain", StringConversion.fromString((String)placement.spreadDomain()));
            }
        }
        if (runInstancesRequest.ramdiskId() != null) {
            request.addParameter("RamdiskId", StringConversion.fromString((String)runInstancesRequest.ramdiskId()));
        }
        if (!(runInstancesRequestSecurityGroupIdsList = runInstancesRequest.securityGroupIds()).isEmpty() || !(runInstancesRequestSecurityGroupIdsList instanceof SdkAutoConstructList)) {
            int securityGroupIdsListIndex = 1;
            for (Object runInstancesRequestSecurityGroupIdsListValue : runInstancesRequestSecurityGroupIdsList) {
                if (runInstancesRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + securityGroupIdsListIndex, StringConversion.fromString((String)runInstancesRequestSecurityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (!(runInstancesRequestSecurityGroupsList = runInstancesRequest.securityGroups()).isEmpty() || !(runInstancesRequestSecurityGroupsList instanceof SdkAutoConstructList)) {
            int securityGroupsListIndex = 1;
            for (String runInstancesRequestSecurityGroupsListValue : runInstancesRequestSecurityGroupsList) {
                if (runInstancesRequestSecurityGroupsListValue != null) {
                    request.addParameter("SecurityGroup." + securityGroupsListIndex, StringConversion.fromString((String)runInstancesRequestSecurityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        if (runInstancesRequest.subnetId() != null) {
            request.addParameter("SubnetId", StringConversion.fromString((String)runInstancesRequest.subnetId()));
        }
        if (runInstancesRequest.userData() != null) {
            request.addParameter("UserData", StringConversion.fromString((String)runInstancesRequest.userData()));
        }
        if (runInstancesRequest.additionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringConversion.fromString((String)runInstancesRequest.additionalInfo()));
        }
        if (runInstancesRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)runInstancesRequest.clientToken()));
        }
        if (runInstancesRequest.disableApiTermination() != null) {
            request.addParameter("DisableApiTermination", StringConversion.fromBoolean((Boolean)runInstancesRequest.disableApiTermination()));
        }
        if (runInstancesRequest.ebsOptimized() != null) {
            request.addParameter("EbsOptimized", StringConversion.fromBoolean((Boolean)runInstancesRequest.ebsOptimized()));
        }
        if ((iamInstanceProfile = runInstancesRequest.iamInstanceProfile()) != null) {
            if (iamInstanceProfile.arn() != null) {
                request.addParameter("IamInstanceProfile.Arn", StringConversion.fromString((String)iamInstanceProfile.arn()));
            }
            if (iamInstanceProfile.name() != null) {
                request.addParameter("IamInstanceProfile.Name", StringConversion.fromString((String)iamInstanceProfile.name()));
            }
        }
        if (runInstancesRequest.instanceInitiatedShutdownBehaviorAsString() != null) {
            request.addParameter("InstanceInitiatedShutdownBehavior", StringConversion.fromString((String)runInstancesRequest.instanceInitiatedShutdownBehaviorAsString()));
        }
        if (!(runInstancesRequestNetworkInterfacesList = runInstancesRequest.networkInterfaces()).isEmpty() || !(runInstancesRequestNetworkInterfacesList instanceof SdkAutoConstructList)) {
            int networkInterfacesListIndex = 1;
            for (Object runInstancesRequestNetworkInterfacesListValue : runInstancesRequestNetworkInterfacesList) {
                List<PrivateIpAddressSpecification> instanceNetworkInterfaceSpecificationPrivateIpAddressesList;
                List<InstanceIpv6Address> instanceNetworkInterfaceSpecificationIpv6AddressesList;
                List<String> instanceNetworkInterfaceSpecificationGroupsList;
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).associatePublicIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringConversion.fromBoolean((Boolean)((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).associatePublicIpAddress()));
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).deleteOnTermination() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringConversion.fromBoolean((Boolean)((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).deleteOnTermination()));
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).description() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Description", StringConversion.fromString((String)((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).description()));
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).deviceIndex() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringConversion.fromInteger((Integer)((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).deviceIndex()));
                }
                if (!(instanceNetworkInterfaceSpecificationGroupsList = ((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).groups()).isEmpty() || !(instanceNetworkInterfaceSpecificationGroupsList instanceof SdkAutoConstructList)) {
                    int groupsListIndex = 1;
                    for (Object instanceNetworkInterfaceSpecificationGroupsListValue : instanceNetworkInterfaceSpecificationGroupsList) {
                        if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringConversion.fromString((String)instanceNetworkInterfaceSpecificationGroupsListValue));
                        }
                        ++groupsListIndex;
                    }
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).ipv6AddressCount() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Ipv6AddressCount", StringConversion.fromInteger((Integer)((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).ipv6AddressCount()));
                }
                if (!(instanceNetworkInterfaceSpecificationIpv6AddressesList = ((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).ipv6Addresses()).isEmpty() || !(instanceNetworkInterfaceSpecificationIpv6AddressesList instanceof SdkAutoConstructList)) {
                    Object instanceNetworkInterfaceSpecificationGroupsListValue;
                    int ipv6AddressesListIndex = 1;
                    instanceNetworkInterfaceSpecificationGroupsListValue = instanceNetworkInterfaceSpecificationIpv6AddressesList.iterator();
                    while (instanceNetworkInterfaceSpecificationGroupsListValue.hasNext()) {
                        InstanceIpv6Address instanceNetworkInterfaceSpecificationIpv6AddressesListValue = (InstanceIpv6Address)instanceNetworkInterfaceSpecificationGroupsListValue.next();
                        if (instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringConversion.fromString((String)instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address()));
                        }
                        ++ipv6AddressesListIndex;
                    }
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).networkInterfaceId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringConversion.fromString((String)((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).networkInterfaceId()));
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).privateIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringConversion.fromString((String)((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).privateIpAddress()));
                }
                if (!(instanceNetworkInterfaceSpecificationPrivateIpAddressesList = ((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).privateIpAddresses()).isEmpty() || !(instanceNetworkInterfaceSpecificationPrivateIpAddressesList instanceof SdkAutoConstructList)) {
                    int privateIpAddressesListIndex = 1;
                    for (PrivateIpAddressSpecification instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue : instanceNetworkInterfaceSpecificationPrivateIpAddressesList) {
                        if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringConversion.fromBoolean((Boolean)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary()));
                        }
                        if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.privateIpAddress() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringConversion.fromString((String)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.privateIpAddress()));
                        }
                        ++privateIpAddressesListIndex;
                    }
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).secondaryPrivateIpAddressCount() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringConversion.fromInteger((Integer)((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).secondaryPrivateIpAddressCount()));
                }
                if (((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).subnetId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringConversion.fromString((String)((InstanceNetworkInterfaceSpecification)runInstancesRequestNetworkInterfacesListValue).subnetId()));
                }
                ++networkInterfacesListIndex;
            }
        }
        if (runInstancesRequest.privateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringConversion.fromString((String)runInstancesRequest.privateIpAddress()));
        }
        if (!(runInstancesRequestElasticGpuSpecificationList = runInstancesRequest.elasticGpuSpecification()).isEmpty() || !(runInstancesRequestElasticGpuSpecificationList instanceof SdkAutoConstructList)) {
            int elasticGpuSpecificationListIndex = 1;
            for (ElasticGpuSpecification runInstancesRequestElasticGpuSpecificationListValue : runInstancesRequestElasticGpuSpecificationList) {
                if (runInstancesRequestElasticGpuSpecificationListValue.type() != null) {
                    request.addParameter("ElasticGpuSpecification." + elasticGpuSpecificationListIndex + ".Type", StringConversion.fromString((String)runInstancesRequestElasticGpuSpecificationListValue.type()));
                }
                ++elasticGpuSpecificationListIndex;
            }
        }
        if (!(runInstancesRequestTagSpecificationsList = runInstancesRequest.tagSpecifications()).isEmpty() || !(runInstancesRequestTagSpecificationsList instanceof SdkAutoConstructList)) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification runInstancesRequestTagSpecificationsListValue : runInstancesRequestTagSpecificationsList) {
                List<Tag> tagSpecificationTagsList;
                if (runInstancesRequestTagSpecificationsListValue.resourceTypeAsString() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringConversion.fromString((String)runInstancesRequestTagSpecificationsListValue.resourceTypeAsString()));
                }
                if (!(tagSpecificationTagsList = runInstancesRequestTagSpecificationsListValue.tags()).isEmpty() || !(tagSpecificationTagsList instanceof SdkAutoConstructList)) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.key() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagSpecificationTagsListValue.key()));
                        }
                        if (tagSpecificationTagsListValue.value() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagSpecificationTagsListValue.value()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

