/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceLimitPrice;

public class PurchaseReservedInstancesOfferingRequestMarshaller
implements Marshaller<Request<PurchaseReservedInstancesOfferingRequest>, PurchaseReservedInstancesOfferingRequest> {
    public Request<PurchaseReservedInstancesOfferingRequest> marshall(PurchaseReservedInstancesOfferingRequest purchaseReservedInstancesOfferingRequest) {
        ReservedInstanceLimitPrice limitPrice;
        if (purchaseReservedInstancesOfferingRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)purchaseReservedInstancesOfferingRequest, "Ec2Client");
        request.addParameter("Action", "PurchaseReservedInstancesOffering");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (purchaseReservedInstancesOfferingRequest.instanceCount() != null) {
            request.addParameter("InstanceCount", StringConversion.fromInteger((Integer)purchaseReservedInstancesOfferingRequest.instanceCount()));
        }
        if (purchaseReservedInstancesOfferingRequest.reservedInstancesOfferingId() != null) {
            request.addParameter("ReservedInstancesOfferingId", StringConversion.fromString((String)purchaseReservedInstancesOfferingRequest.reservedInstancesOfferingId()));
        }
        if ((limitPrice = purchaseReservedInstancesOfferingRequest.limitPrice()) != null) {
            if (limitPrice.amount() != null) {
                request.addParameter("LimitPrice.Amount", StringConversion.fromDouble((Double)limitPrice.amount()));
            }
            if (limitPrice.currencyCodeAsString() != null) {
                request.addParameter("LimitPrice.CurrencyCode", StringConversion.fromString((String)limitPrice.currencyCodeAsString()));
            }
        }
        return request;
    }
}

