/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachmentChanges;

public class ModifyNetworkInterfaceAttributeRequestMarshaller
implements Marshaller<Request<ModifyNetworkInterfaceAttributeRequest>, ModifyNetworkInterfaceAttributeRequest> {
    public Request<ModifyNetworkInterfaceAttributeRequest> marshall(ModifyNetworkInterfaceAttributeRequest modifyNetworkInterfaceAttributeRequest) {
        List<String> modifyNetworkInterfaceAttributeRequestGroupsList;
        if (modifyNetworkInterfaceAttributeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyNetworkInterfaceAttributeRequest, "Ec2Client");
        request.addParameter("Action", "ModifyNetworkInterfaceAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        NetworkInterfaceAttachmentChanges attachment = modifyNetworkInterfaceAttributeRequest.attachment();
        if (attachment != null) {
            if (attachment.attachmentId() != null) {
                request.addParameter("Attachment.AttachmentId", StringConversion.fromString((String)attachment.attachmentId()));
            }
            if (attachment.deleteOnTermination() != null) {
                request.addParameter("Attachment.DeleteOnTermination", StringConversion.fromBoolean((Boolean)attachment.deleteOnTermination()));
            }
        }
        if (modifyNetworkInterfaceAttributeRequest.description() != null) {
            request.addParameter("Description.Value", StringConversion.fromString((String)modifyNetworkInterfaceAttributeRequest.description()));
        }
        if (!(modifyNetworkInterfaceAttributeRequestGroupsList = modifyNetworkInterfaceAttributeRequest.groups()).isEmpty() || !(modifyNetworkInterfaceAttributeRequestGroupsList instanceof SdkAutoConstructList)) {
            int groupsListIndex = 1;
            for (String modifyNetworkInterfaceAttributeRequestGroupsListValue : modifyNetworkInterfaceAttributeRequestGroupsList) {
                if (modifyNetworkInterfaceAttributeRequestGroupsListValue != null) {
                    request.addParameter("SecurityGroupId." + groupsListIndex, StringConversion.fromString((String)modifyNetworkInterfaceAttributeRequestGroupsListValue));
                }
                ++groupsListIndex;
            }
        }
        if (modifyNetworkInterfaceAttributeRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringConversion.fromString((String)modifyNetworkInterfaceAttributeRequest.networkInterfaceId()));
        }
        if (modifyNetworkInterfaceAttributeRequest.sourceDestCheck() != null) {
            request.addParameter("SourceDestCheck.Value", StringConversion.fromBoolean((Boolean)modifyNetworkInterfaceAttributeRequest.sourceDestCheck()));
        }
        return request;
    }
}

