/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ModifyHostsRequest;

public class ModifyHostsRequestMarshaller
implements Marshaller<Request<ModifyHostsRequest>, ModifyHostsRequest> {
    public Request<ModifyHostsRequest> marshall(ModifyHostsRequest modifyHostsRequest) {
        List<String> modifyHostsRequestHostIdsList;
        if (modifyHostsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyHostsRequest, "Ec2Client");
        request.addParameter("Action", "ModifyHosts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyHostsRequest.autoPlacementAsString() != null) {
            request.addParameter("AutoPlacement", StringConversion.fromString((String)modifyHostsRequest.autoPlacementAsString()));
        }
        if (!(modifyHostsRequestHostIdsList = modifyHostsRequest.hostIds()).isEmpty() || !(modifyHostsRequestHostIdsList instanceof SdkAutoConstructList)) {
            int hostIdsListIndex = 1;
            for (String modifyHostsRequestHostIdsListValue : modifyHostsRequestHostIdsList) {
                if (modifyHostsRequestHostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex, StringConversion.fromString((String)modifyHostsRequestHostIdsListValue));
                }
                ++hostIdsListIndex;
            }
        }
        return request;
    }
}

