/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteRequest;
import software.amazon.awssdk.services.ec2.model.TargetConfigurationRequest;

public class GetReservedInstancesExchangeQuoteRequestMarshaller
implements Marshaller<Request<GetReservedInstancesExchangeQuoteRequest>, GetReservedInstancesExchangeQuoteRequest> {
    public Request<GetReservedInstancesExchangeQuoteRequest> marshall(GetReservedInstancesExchangeQuoteRequest getReservedInstancesExchangeQuoteRequest) {
        List<TargetConfigurationRequest> getReservedInstancesExchangeQuoteRequestTargetConfigurationsList;
        if (getReservedInstancesExchangeQuoteRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getReservedInstancesExchangeQuoteRequest, "Ec2Client");
        request.addParameter("Action", "GetReservedInstancesExchangeQuote");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> getReservedInstancesExchangeQuoteRequestReservedInstanceIdsList = getReservedInstancesExchangeQuoteRequest.reservedInstanceIds();
        if (!getReservedInstancesExchangeQuoteRequestReservedInstanceIdsList.isEmpty() || !(getReservedInstancesExchangeQuoteRequestReservedInstanceIdsList instanceof SdkAutoConstructList)) {
            int reservedInstanceIdsListIndex = 1;
            for (String getReservedInstancesExchangeQuoteRequestReservedInstanceIdsListValue : getReservedInstancesExchangeQuoteRequestReservedInstanceIdsList) {
                if (getReservedInstancesExchangeQuoteRequestReservedInstanceIdsListValue != null) {
                    request.addParameter("ReservedInstanceId." + reservedInstanceIdsListIndex, StringConversion.fromString((String)getReservedInstancesExchangeQuoteRequestReservedInstanceIdsListValue));
                }
                ++reservedInstanceIdsListIndex;
            }
        }
        if (!(getReservedInstancesExchangeQuoteRequestTargetConfigurationsList = getReservedInstancesExchangeQuoteRequest.targetConfigurations()).isEmpty() || !(getReservedInstancesExchangeQuoteRequestTargetConfigurationsList instanceof SdkAutoConstructList)) {
            int targetConfigurationsListIndex = 1;
            for (TargetConfigurationRequest getReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue : getReservedInstancesExchangeQuoteRequestTargetConfigurationsList) {
                if (getReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue.instanceCount() != null) {
                    request.addParameter("TargetConfiguration." + targetConfigurationsListIndex + ".InstanceCount", StringConversion.fromInteger((Integer)getReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue.instanceCount()));
                }
                if (getReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue.offeringId() != null) {
                    request.addParameter("TargetConfiguration." + targetConfigurationsListIndex + ".OfferingId", StringConversion.fromString((String)getReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue.offeringId()));
                }
                ++targetConfigurationsListIndex;
            }
        }
        return request;
    }
}

