/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest;

public class DescribeVpcAttributeRequestMarshaller
implements Marshaller<Request<DescribeVpcAttributeRequest>, DescribeVpcAttributeRequest> {
    public Request<DescribeVpcAttributeRequest> marshall(DescribeVpcAttributeRequest describeVpcAttributeRequest) {
        if (describeVpcAttributeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeVpcAttributeRequest, "Ec2Client");
        request.addParameter("Action", "DescribeVpcAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeVpcAttributeRequest.attributeAsString() != null) {
            request.addParameter("Attribute", StringConversion.fromString((String)describeVpcAttributeRequest.attributeAsString()));
        }
        if (describeVpcAttributeRequest.vpcId() != null) {
            request.addParameter("VpcId", StringConversion.fromString((String)describeVpcAttributeRequest.vpcId()));
        }
        return request;
    }
}

