/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest;

public class DescribeVolumeAttributeRequestMarshaller
implements Marshaller<Request<DescribeVolumeAttributeRequest>, DescribeVolumeAttributeRequest> {
    public Request<DescribeVolumeAttributeRequest> marshall(DescribeVolumeAttributeRequest describeVolumeAttributeRequest) {
        if (describeVolumeAttributeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeVolumeAttributeRequest, "Ec2Client");
        request.addParameter("Action", "DescribeVolumeAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeVolumeAttributeRequest.attributeAsString() != null) {
            request.addParameter("Attribute", StringConversion.fromString((String)describeVolumeAttributeRequest.attributeAsString()));
        }
        if (describeVolumeAttributeRequest.volumeId() != null) {
            request.addParameter("VolumeId", StringConversion.fromString((String)describeVolumeAttributeRequest.volumeId()));
        }
        return request;
    }
}

