/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest;

public class DescribeSpotFleetRequestHistoryRequestMarshaller
implements Marshaller<Request<DescribeSpotFleetRequestHistoryRequest>, DescribeSpotFleetRequestHistoryRequest> {
    public Request<DescribeSpotFleetRequestHistoryRequest> marshall(DescribeSpotFleetRequestHistoryRequest describeSpotFleetRequestHistoryRequest) {
        if (describeSpotFleetRequestHistoryRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeSpotFleetRequestHistoryRequest, "Ec2Client");
        request.addParameter("Action", "DescribeSpotFleetRequestHistory");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSpotFleetRequestHistoryRequest.eventTypeAsString() != null) {
            request.addParameter("EventType", StringConversion.fromString((String)describeSpotFleetRequestHistoryRequest.eventTypeAsString()));
        }
        if (describeSpotFleetRequestHistoryRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeSpotFleetRequestHistoryRequest.maxResults()));
        }
        if (describeSpotFleetRequestHistoryRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeSpotFleetRequestHistoryRequest.nextToken()));
        }
        if (describeSpotFleetRequestHistoryRequest.spotFleetRequestId() != null) {
            request.addParameter("SpotFleetRequestId", StringConversion.fromString((String)describeSpotFleetRequestHistoryRequest.spotFleetRequestId()));
        }
        if (describeSpotFleetRequestHistoryRequest.startTime() != null) {
            request.addParameter("StartTime", StringConversion.fromInstant((Instant)describeSpotFleetRequestHistoryRequest.startTime()));
        }
        return request;
    }
}

