/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest;

public class DescribeSpotFleetInstancesRequestMarshaller
implements Marshaller<Request<DescribeSpotFleetInstancesRequest>, DescribeSpotFleetInstancesRequest> {
    public Request<DescribeSpotFleetInstancesRequest> marshall(DescribeSpotFleetInstancesRequest describeSpotFleetInstancesRequest) {
        if (describeSpotFleetInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeSpotFleetInstancesRequest, "Ec2Client");
        request.addParameter("Action", "DescribeSpotFleetInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSpotFleetInstancesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeSpotFleetInstancesRequest.maxResults()));
        }
        if (describeSpotFleetInstancesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeSpotFleetInstancesRequest.nextToken()));
        }
        if (describeSpotFleetInstancesRequest.spotFleetRequestId() != null) {
            request.addParameter("SpotFleetRequestId", StringConversion.fromString((String)describeSpotFleetInstancesRequest.spotFleetRequestId()));
        }
        return request;
    }
}

