/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.SlotStartTimeRangeRequest;

public class DescribeScheduledInstancesRequestMarshaller
implements Marshaller<Request<DescribeScheduledInstancesRequest>, DescribeScheduledInstancesRequest> {
    public Request<DescribeScheduledInstancesRequest> marshall(DescribeScheduledInstancesRequest describeScheduledInstancesRequest) {
        SlotStartTimeRangeRequest slotStartTimeRange;
        List<String> describeScheduledInstancesRequestScheduledInstanceIdsList;
        if (describeScheduledInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeScheduledInstancesRequest, "Ec2Client");
        request.addParameter("Action", "DescribeScheduledInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeScheduledInstancesRequestFiltersList = describeScheduledInstancesRequest.filters();
        if (!describeScheduledInstancesRequestFiltersList.isEmpty() || !(describeScheduledInstancesRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeScheduledInstancesRequestFiltersListValue : describeScheduledInstancesRequestFiltersList) {
                List<String> filterValuesList;
                if (describeScheduledInstancesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeScheduledInstancesRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeScheduledInstancesRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeScheduledInstancesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeScheduledInstancesRequest.maxResults()));
        }
        if (describeScheduledInstancesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeScheduledInstancesRequest.nextToken()));
        }
        if (!(describeScheduledInstancesRequestScheduledInstanceIdsList = describeScheduledInstancesRequest.scheduledInstanceIds()).isEmpty() || !(describeScheduledInstancesRequestScheduledInstanceIdsList instanceof SdkAutoConstructList)) {
            int scheduledInstanceIdsListIndex = 1;
            for (String describeScheduledInstancesRequestScheduledInstanceIdsListValue : describeScheduledInstancesRequestScheduledInstanceIdsList) {
                if (describeScheduledInstancesRequestScheduledInstanceIdsListValue != null) {
                    request.addParameter("ScheduledInstanceId." + scheduledInstanceIdsListIndex, StringConversion.fromString((String)describeScheduledInstancesRequestScheduledInstanceIdsListValue));
                }
                ++scheduledInstanceIdsListIndex;
            }
        }
        if ((slotStartTimeRange = describeScheduledInstancesRequest.slotStartTimeRange()) != null) {
            if (slotStartTimeRange.earliestTime() != null) {
                request.addParameter("SlotStartTimeRange.EarliestTime", StringConversion.fromInstant((Instant)slotStartTimeRange.earliestTime()));
            }
            if (slotStartTimeRange.latestTime() != null) {
                request.addParameter("SlotStartTimeRange.LatestTime", StringConversion.fromInstant((Instant)slotStartTimeRange.latestTime()));
            }
        }
        return request;
    }
}

