/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeRouteTablesRequestMarshaller
implements Marshaller<Request<DescribeRouteTablesRequest>, DescribeRouteTablesRequest> {
    public Request<DescribeRouteTablesRequest> marshall(DescribeRouteTablesRequest describeRouteTablesRequest) {
        List<String> describeRouteTablesRequestRouteTableIdsList;
        if (describeRouteTablesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeRouteTablesRequest, "Ec2Client");
        request.addParameter("Action", "DescribeRouteTables");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeRouteTablesRequestFiltersList = describeRouteTablesRequest.filters();
        if (!describeRouteTablesRequestFiltersList.isEmpty() || !(describeRouteTablesRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeRouteTablesRequestFiltersListValue : describeRouteTablesRequestFiltersList) {
                List<String> filterValuesList;
                if (describeRouteTablesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeRouteTablesRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeRouteTablesRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeRouteTablesRequestRouteTableIdsList = describeRouteTablesRequest.routeTableIds()).isEmpty() || !(describeRouteTablesRequestRouteTableIdsList instanceof SdkAutoConstructList)) {
            int routeTableIdsListIndex = 1;
            for (String describeRouteTablesRequestRouteTableIdsListValue : describeRouteTablesRequestRouteTableIdsList) {
                if (describeRouteTablesRequestRouteTableIdsListValue != null) {
                    request.addParameter("RouteTableId." + routeTableIdsListIndex, StringConversion.fromString((String)describeRouteTablesRequestRouteTableIdsListValue));
                }
                ++routeTableIdsListIndex;
            }
        }
        return request;
    }
}

