/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeNetworkInterfacesRequestMarshaller
implements Marshaller<Request<DescribeNetworkInterfacesRequest>, DescribeNetworkInterfacesRequest> {
    public Request<DescribeNetworkInterfacesRequest> marshall(DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest) {
        List<String> describeNetworkInterfacesRequestNetworkInterfaceIdsList;
        if (describeNetworkInterfacesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeNetworkInterfacesRequest, "Ec2Client");
        request.addParameter("Action", "DescribeNetworkInterfaces");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeNetworkInterfacesRequestFiltersList = describeNetworkInterfacesRequest.filters();
        if (!describeNetworkInterfacesRequestFiltersList.isEmpty() || !(describeNetworkInterfacesRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeNetworkInterfacesRequestFiltersListValue : describeNetworkInterfacesRequestFiltersList) {
                List<String> filterValuesList;
                if (describeNetworkInterfacesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeNetworkInterfacesRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeNetworkInterfacesRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeNetworkInterfacesRequestNetworkInterfaceIdsList = describeNetworkInterfacesRequest.networkInterfaceIds()).isEmpty() || !(describeNetworkInterfacesRequestNetworkInterfaceIdsList instanceof SdkAutoConstructList)) {
            int networkInterfaceIdsListIndex = 1;
            for (String describeNetworkInterfacesRequestNetworkInterfaceIdsListValue : describeNetworkInterfacesRequestNetworkInterfaceIdsList) {
                if (describeNetworkInterfacesRequestNetworkInterfaceIdsListValue != null) {
                    request.addParameter("NetworkInterfaceId." + networkInterfaceIdsListIndex, StringConversion.fromString((String)describeNetworkInterfacesRequestNetworkInterfaceIdsListValue));
                }
                ++networkInterfaceIdsListIndex;
            }
        }
        return request;
    }
}

