/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeRequest;

public class DescribeNetworkInterfaceAttributeRequestMarshaller
implements Marshaller<Request<DescribeNetworkInterfaceAttributeRequest>, DescribeNetworkInterfaceAttributeRequest> {
    public Request<DescribeNetworkInterfaceAttributeRequest> marshall(DescribeNetworkInterfaceAttributeRequest describeNetworkInterfaceAttributeRequest) {
        if (describeNetworkInterfaceAttributeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeNetworkInterfaceAttributeRequest, "Ec2Client");
        request.addParameter("Action", "DescribeNetworkInterfaceAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeNetworkInterfaceAttributeRequest.attributeAsString() != null) {
            request.addParameter("Attribute", StringConversion.fromString((String)describeNetworkInterfaceAttributeRequest.attributeAsString()));
        }
        if (describeNetworkInterfaceAttributeRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringConversion.fromString((String)describeNetworkInterfaceAttributeRequest.networkInterfaceId()));
        }
        return request;
    }
}

