/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeElasticGpusRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeElasticGpusRequestMarshaller
implements Marshaller<Request<DescribeElasticGpusRequest>, DescribeElasticGpusRequest> {
    public Request<DescribeElasticGpusRequest> marshall(DescribeElasticGpusRequest describeElasticGpusRequest) {
        List<Filter> describeElasticGpusRequestFiltersList;
        if (describeElasticGpusRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeElasticGpusRequest, "Ec2Client");
        request.addParameter("Action", "DescribeElasticGpus");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeElasticGpusRequestElasticGpuIdsList = describeElasticGpusRequest.elasticGpuIds();
        if (!describeElasticGpusRequestElasticGpuIdsList.isEmpty() || !(describeElasticGpusRequestElasticGpuIdsList instanceof SdkAutoConstructList)) {
            int elasticGpuIdsListIndex = 1;
            for (String describeElasticGpusRequestElasticGpuIdsListValue : describeElasticGpusRequestElasticGpuIdsList) {
                if (describeElasticGpusRequestElasticGpuIdsListValue != null) {
                    request.addParameter("ElasticGpuId." + elasticGpuIdsListIndex, StringConversion.fromString((String)describeElasticGpusRequestElasticGpuIdsListValue));
                }
                ++elasticGpuIdsListIndex;
            }
        }
        if (!(describeElasticGpusRequestFiltersList = describeElasticGpusRequest.filters()).isEmpty() || !(describeElasticGpusRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeElasticGpusRequestFiltersListValue : describeElasticGpusRequestFiltersList) {
                List<String> filterValuesList;
                if (describeElasticGpusRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeElasticGpusRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeElasticGpusRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeElasticGpusRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeElasticGpusRequest.maxResults()));
        }
        if (describeElasticGpusRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeElasticGpusRequest.nextToken()));
        }
        return request;
    }
}

