/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeClassicLinkInstancesRequestMarshaller
implements Marshaller<Request<DescribeClassicLinkInstancesRequest>, DescribeClassicLinkInstancesRequest> {
    public Request<DescribeClassicLinkInstancesRequest> marshall(DescribeClassicLinkInstancesRequest describeClassicLinkInstancesRequest) {
        List<String> describeClassicLinkInstancesRequestInstanceIdsList;
        if (describeClassicLinkInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeClassicLinkInstancesRequest, "Ec2Client");
        request.addParameter("Action", "DescribeClassicLinkInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeClassicLinkInstancesRequestFiltersList = describeClassicLinkInstancesRequest.filters();
        if (!describeClassicLinkInstancesRequestFiltersList.isEmpty() || !(describeClassicLinkInstancesRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeClassicLinkInstancesRequestFiltersListValue : describeClassicLinkInstancesRequestFiltersList) {
                List<String> filterValuesList;
                if (describeClassicLinkInstancesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeClassicLinkInstancesRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeClassicLinkInstancesRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeClassicLinkInstancesRequestInstanceIdsList = describeClassicLinkInstancesRequest.instanceIds()).isEmpty() || !(describeClassicLinkInstancesRequestInstanceIdsList instanceof SdkAutoConstructList)) {
            int instanceIdsListIndex = 1;
            for (String describeClassicLinkInstancesRequestInstanceIdsListValue : describeClassicLinkInstancesRequestInstanceIdsList) {
                if (describeClassicLinkInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringConversion.fromString((String)describeClassicLinkInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (describeClassicLinkInstancesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeClassicLinkInstancesRequest.maxResults()));
        }
        if (describeClassicLinkInstancesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeClassicLinkInstancesRequest.nextToken()));
        }
        return request;
    }
}

