/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CopySnapshotRequest;

public class CopySnapshotRequestMarshaller
implements Marshaller<Request<CopySnapshotRequest>, CopySnapshotRequest> {
    public Request<CopySnapshotRequest> marshall(CopySnapshotRequest copySnapshotRequest) {
        if (copySnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)copySnapshotRequest, "Ec2Client");
        request.addParameter("Action", "CopySnapshot");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (copySnapshotRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)copySnapshotRequest.description()));
        }
        if (copySnapshotRequest.destinationRegion() != null) {
            request.addParameter("DestinationRegion", StringConversion.fromString((String)copySnapshotRequest.destinationRegion()));
        }
        if (copySnapshotRequest.encrypted() != null) {
            request.addParameter("Encrypted", StringConversion.fromBoolean((Boolean)copySnapshotRequest.encrypted()));
        }
        if (copySnapshotRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringConversion.fromString((String)copySnapshotRequest.kmsKeyId()));
        }
        if (copySnapshotRequest.presignedUrl() != null) {
            request.addParameter("PresignedUrl", StringConversion.fromString((String)copySnapshotRequest.presignedUrl()));
        }
        if (copySnapshotRequest.sourceRegion() != null) {
            request.addParameter("SourceRegion", StringConversion.fromString((String)copySnapshotRequest.sourceRegion()));
        }
        if (copySnapshotRequest.sourceSnapshotId() != null) {
            request.addParameter("SourceSnapshotId", StringConversion.fromString((String)copySnapshotRequest.sourceSnapshotId()));
        }
        return request;
    }
}

