/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest;

public class CancelImportTaskRequestMarshaller
implements Marshaller<Request<CancelImportTaskRequest>, CancelImportTaskRequest> {
    public Request<CancelImportTaskRequest> marshall(CancelImportTaskRequest cancelImportTaskRequest) {
        if (cancelImportTaskRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)cancelImportTaskRequest, "Ec2Client");
        request.addParameter("Action", "CancelImportTask");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (cancelImportTaskRequest.cancelReason() != null) {
            request.addParameter("CancelReason", StringConversion.fromString((String)cancelImportTaskRequest.cancelReason()));
        }
        if (cancelImportTaskRequest.importTaskId() != null) {
            request.addParameter("ImportTaskId", StringConversion.fromString((String)cancelImportTaskRequest.importTaskId()));
        }
        return request;
    }
}

