/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressRequest;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpRange;
import software.amazon.awssdk.services.ec2.model.Ipv6Range;
import software.amazon.awssdk.services.ec2.model.PrefixListId;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPair;

public class AuthorizeSecurityGroupEgressRequestMarshaller
implements Marshaller<Request<AuthorizeSecurityGroupEgressRequest>, AuthorizeSecurityGroupEgressRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<AuthorizeSecurityGroupEgressRequest> marshall(AuthorizeSecurityGroupEgressRequest authorizeSecurityGroupEgressRequest) {
        List<IpPermission> authorizeSecurityGroupEgressRequestIpPermissionsList;
        if (authorizeSecurityGroupEgressRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)authorizeSecurityGroupEgressRequest, "Ec2Client");
        request.addParameter("Action", "AuthorizeSecurityGroupEgress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeSecurityGroupEgressRequest.groupId() != null) {
            request.addParameter("GroupId", StringConversion.fromString((String)authorizeSecurityGroupEgressRequest.groupId()));
        }
        if (!(authorizeSecurityGroupEgressRequestIpPermissionsList = authorizeSecurityGroupEgressRequest.ipPermissions()).isEmpty() || !(authorizeSecurityGroupEgressRequestIpPermissionsList instanceof SdkAutoConstructList)) {
            int ipPermissionsListIndex = 1;
            for (IpPermission authorizeSecurityGroupEgressRequestIpPermissionsListValue : authorizeSecurityGroupEgressRequestIpPermissionsList) {
                List<IpRange> list;
                List<UserIdGroupPair> ipPermissionUserIdGroupPairsList;
                List<PrefixListId> ipPermissionPrefixListIdsList;
                List<Ipv6Range> ipPermissionIpv6RangesList;
                if (authorizeSecurityGroupEgressRequestIpPermissionsListValue.fromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort", StringConversion.fromInteger((Integer)authorizeSecurityGroupEgressRequestIpPermissionsListValue.fromPort()));
                }
                if (authorizeSecurityGroupEgressRequestIpPermissionsListValue.ipProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol", StringConversion.fromString((String)authorizeSecurityGroupEgressRequestIpPermissionsListValue.ipProtocol()));
                }
                if (!(ipPermissionIpv6RangesList = authorizeSecurityGroupEgressRequestIpPermissionsListValue.ipv6Ranges()).isEmpty() || !(ipPermissionIpv6RangesList instanceof SdkAutoConstructList)) {
                    int ipv6RangesListIndex = 1;
                    for (Ipv6Range ipv6Range : ipPermissionIpv6RangesList) {
                        if (ipv6Range.cidrIpv6() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Ipv6Ranges." + ipv6RangesListIndex + ".CidrIpv6", StringConversion.fromString((String)ipv6Range.cidrIpv6()));
                        }
                        if (ipv6Range.description() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Ipv6Ranges." + ipv6RangesListIndex + ".Description", StringConversion.fromString((String)ipv6Range.description()));
                        }
                        ++ipv6RangesListIndex;
                    }
                }
                if (!(ipPermissionPrefixListIdsList = authorizeSecurityGroupEgressRequestIpPermissionsListValue.prefixListIds()).isEmpty() || !(ipPermissionPrefixListIdsList instanceof SdkAutoConstructList)) {
                    int prefixListIdsListIndex = 1;
                    for (Object ipPermissionPrefixListIdsListValue : ipPermissionPrefixListIdsList) {
                        if (((PrefixListId)ipPermissionPrefixListIdsListValue).description() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds." + prefixListIdsListIndex + ".Description", StringConversion.fromString((String)((PrefixListId)ipPermissionPrefixListIdsListValue).description()));
                        }
                        if (((PrefixListId)ipPermissionPrefixListIdsListValue).prefixListId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds." + prefixListIdsListIndex + ".PrefixListId", StringConversion.fromString((String)((PrefixListId)ipPermissionPrefixListIdsListValue).prefixListId()));
                        }
                        ++prefixListIdsListIndex;
                    }
                }
                if (authorizeSecurityGroupEgressRequestIpPermissionsListValue.toPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort", StringConversion.fromInteger((Integer)authorizeSecurityGroupEgressRequestIpPermissionsListValue.toPort()));
                }
                if (!(ipPermissionUserIdGroupPairsList = authorizeSecurityGroupEgressRequestIpPermissionsListValue.userIdGroupPairs()).isEmpty() || !(ipPermissionUserIdGroupPairsList instanceof SdkAutoConstructList)) {
                    Object ipPermissionPrefixListIdsListValue;
                    boolean bl = true;
                    ipPermissionPrefixListIdsListValue = ipPermissionUserIdGroupPairsList.iterator();
                    while (ipPermissionPrefixListIdsListValue.hasNext()) {
                        void var10_18;
                        UserIdGroupPair ipPermissionUserIdGroupPairsListValue = (UserIdGroupPair)ipPermissionPrefixListIdsListValue.next();
                        if (ipPermissionUserIdGroupPairsListValue.description() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".Description", StringConversion.fromString((String)ipPermissionUserIdGroupPairsListValue.description()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.groupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".GroupId", StringConversion.fromString((String)ipPermissionUserIdGroupPairsListValue.groupId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.groupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".GroupName", StringConversion.fromString((String)ipPermissionUserIdGroupPairsListValue.groupName()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.peeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".PeeringStatus", StringConversion.fromString((String)ipPermissionUserIdGroupPairsListValue.peeringStatus()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.userId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".UserId", StringConversion.fromString((String)ipPermissionUserIdGroupPairsListValue.userId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.vpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".VpcId", StringConversion.fromString((String)ipPermissionUserIdGroupPairsListValue.vpcId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.vpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".VpcPeeringConnectionId", StringConversion.fromString((String)ipPermissionUserIdGroupPairsListValue.vpcPeeringConnectionId()));
                        }
                        ++var10_18;
                    }
                }
                if (!(list = authorizeSecurityGroupEgressRequestIpPermissionsListValue.ipv4Ranges()).isEmpty() || !(list instanceof SdkAutoConstructList)) {
                    int ipv4RangesListIndex = 1;
                    for (IpRange ipPermissionIpv4RangesListValue : list) {
                        if (ipPermissionIpv4RangesListValue.cidrIp() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipv4RangesListIndex + ".CidrIp", StringConversion.fromString((String)ipPermissionIpv4RangesListValue.cidrIp()));
                        }
                        if (ipPermissionIpv4RangesListValue.description() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipv4RangesListIndex + ".Description", StringConversion.fromString((String)ipPermissionIpv4RangesListValue.description()));
                        }
                        ++ipv4RangesListIndex;
                    }
                }
                ++ipPermissionsListIndex;
            }
        }
        if (authorizeSecurityGroupEgressRequest.cidrIp() != null) {
            request.addParameter("CidrIp", StringConversion.fromString((String)authorizeSecurityGroupEgressRequest.cidrIp()));
        }
        if (authorizeSecurityGroupEgressRequest.fromPort() != null) {
            request.addParameter("FromPort", StringConversion.fromInteger((Integer)authorizeSecurityGroupEgressRequest.fromPort()));
        }
        if (authorizeSecurityGroupEgressRequest.ipProtocol() != null) {
            request.addParameter("IpProtocol", StringConversion.fromString((String)authorizeSecurityGroupEgressRequest.ipProtocol()));
        }
        if (authorizeSecurityGroupEgressRequest.toPort() != null) {
            request.addParameter("ToPort", StringConversion.fromInteger((Integer)authorizeSecurityGroupEgressRequest.toPort()));
        }
        if (authorizeSecurityGroupEgressRequest.sourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName", StringConversion.fromString((String)authorizeSecurityGroupEgressRequest.sourceSecurityGroupName()));
        }
        if (authorizeSecurityGroupEgressRequest.sourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId", StringConversion.fromString((String)authorizeSecurityGroupEgressRequest.sourceSecurityGroupOwnerId()));
        }
        return request;
    }
}

