/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest;

public class AttachNetworkInterfaceRequestMarshaller
implements Marshaller<Request<AttachNetworkInterfaceRequest>, AttachNetworkInterfaceRequest> {
    public Request<AttachNetworkInterfaceRequest> marshall(AttachNetworkInterfaceRequest attachNetworkInterfaceRequest) {
        if (attachNetworkInterfaceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)attachNetworkInterfaceRequest, "Ec2Client");
        request.addParameter("Action", "AttachNetworkInterface");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachNetworkInterfaceRequest.deviceIndex() != null) {
            request.addParameter("DeviceIndex", StringConversion.fromInteger((Integer)attachNetworkInterfaceRequest.deviceIndex()));
        }
        if (attachNetworkInterfaceRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)attachNetworkInterfaceRequest.instanceId()));
        }
        if (attachNetworkInterfaceRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringConversion.fromString((String)attachNetworkInterfaceRequest.networkInterfaceId()));
        }
        return request;
    }
}

