/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockRequest;

public class AssociateVpcCidrBlockRequestMarshaller
implements Marshaller<Request<AssociateVpcCidrBlockRequest>, AssociateVpcCidrBlockRequest> {
    public Request<AssociateVpcCidrBlockRequest> marshall(AssociateVpcCidrBlockRequest associateVpcCidrBlockRequest) {
        if (associateVpcCidrBlockRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)associateVpcCidrBlockRequest, "Ec2Client");
        request.addParameter("Action", "AssociateVpcCidrBlock");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (associateVpcCidrBlockRequest.amazonProvidedIpv6CidrBlock() != null) {
            request.addParameter("AmazonProvidedIpv6CidrBlock", StringConversion.fromBoolean((Boolean)associateVpcCidrBlockRequest.amazonProvidedIpv6CidrBlock()));
        }
        if (associateVpcCidrBlockRequest.cidrBlock() != null) {
            request.addParameter("CidrBlock", StringConversion.fromString((String)associateVpcCidrBlockRequest.cidrBlock()));
        }
        if (associateVpcCidrBlockRequest.vpcId() != null) {
            request.addParameter("VpcId", StringConversion.fromString((String)associateVpcCidrBlockRequest.vpcId()));
        }
        return request;
    }
}

