/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteRequest;
import software.amazon.awssdk.services.ec2.model.TargetConfigurationRequest;

public class AcceptReservedInstancesExchangeQuoteRequestMarshaller
implements Marshaller<Request<AcceptReservedInstancesExchangeQuoteRequest>, AcceptReservedInstancesExchangeQuoteRequest> {
    public Request<AcceptReservedInstancesExchangeQuoteRequest> marshall(AcceptReservedInstancesExchangeQuoteRequest acceptReservedInstancesExchangeQuoteRequest) {
        List<TargetConfigurationRequest> acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsList;
        if (acceptReservedInstancesExchangeQuoteRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)acceptReservedInstancesExchangeQuoteRequest, "Ec2Client");
        request.addParameter("Action", "AcceptReservedInstancesExchangeQuote");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> acceptReservedInstancesExchangeQuoteRequestReservedInstanceIdsList = acceptReservedInstancesExchangeQuoteRequest.reservedInstanceIds();
        if (!acceptReservedInstancesExchangeQuoteRequestReservedInstanceIdsList.isEmpty() || !(acceptReservedInstancesExchangeQuoteRequestReservedInstanceIdsList instanceof SdkAutoConstructList)) {
            int reservedInstanceIdsListIndex = 1;
            for (String acceptReservedInstancesExchangeQuoteRequestReservedInstanceIdsListValue : acceptReservedInstancesExchangeQuoteRequestReservedInstanceIdsList) {
                if (acceptReservedInstancesExchangeQuoteRequestReservedInstanceIdsListValue != null) {
                    request.addParameter("ReservedInstanceId." + reservedInstanceIdsListIndex, StringConversion.fromString((String)acceptReservedInstancesExchangeQuoteRequestReservedInstanceIdsListValue));
                }
                ++reservedInstanceIdsListIndex;
            }
        }
        if (!(acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsList = acceptReservedInstancesExchangeQuoteRequest.targetConfigurations()).isEmpty() || !(acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsList instanceof SdkAutoConstructList)) {
            int targetConfigurationsListIndex = 1;
            for (TargetConfigurationRequest acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue : acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsList) {
                if (acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue.instanceCount() != null) {
                    request.addParameter("TargetConfiguration." + targetConfigurationsListIndex + ".InstanceCount", StringConversion.fromInteger((Integer)acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue.instanceCount()));
                }
                if (acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue.offeringId() != null) {
                    request.addParameter("TargetConfiguration." + targetConfigurationsListIndex + ".OfferingId", StringConversion.fromString((String)acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue.offeringId()));
                }
                ++targetConfigurationsListIndex;
            }
        }
        return request;
    }
}

