/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.ec2.model.TagDescription;

public class DescribeTagsIterable
implements SdkIterable<DescribeTagsResponse> {
    private final Ec2Client client;
    private final DescribeTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTagsIterable(Ec2Client client, DescribeTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeTagsResponseFetcher();
    }

    public Iterator<DescribeTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TagDescription> tags() {
        Function<DescribeTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeTagsIterable resume(DescribeTagsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeTagsIterable(this.client, (DescribeTagsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeTagsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeTagsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeTagsResponseFetcher
    implements SyncPageFetcher<DescribeTagsResponse> {
        private DescribeTagsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTagsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public DescribeTagsResponse nextPage(DescribeTagsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTagsIterable.this.client.describeTags(DescribeTagsIterable.this.firstRequest);
            }
            return DescribeTagsIterable.this.client.describeTags((DescribeTagsRequest)((Object)DescribeTagsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

