/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetConfiguration
implements ToCopyableBuilder<Builder, TargetConfiguration> {
    private final Integer instanceCount;
    private final String offeringId;

    private TargetConfiguration(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.offeringId = builder.offeringId;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public String offeringId() {
        return this.offeringId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetConfiguration)) {
            return false;
        }
        TargetConfiguration other = (TargetConfiguration)obj;
        return Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.offeringId(), other.offeringId());
    }

    public String toString() {
        return ToString.builder((String)"TargetConfiguration").add("InstanceCount", (Object)this.instanceCount()).add("OfferingId", (Object)this.offeringId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "OfferingId": {
                return Optional.ofNullable(clazz.cast(this.offeringId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetConfiguration model) {
            this.instanceCount(model.instanceCount);
            this.offeringId(model.offeringId);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public TargetConfiguration build() {
            return new TargetConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TargetConfiguration> {
        public Builder instanceCount(Integer var1);

        public Builder offeringId(String var1);
    }
}

