/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.UserBucketDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotDetail
implements ToCopyableBuilder<Builder, SnapshotDetail> {
    private final String description;
    private final String deviceName;
    private final Double diskImageSize;
    private final String format;
    private final String progress;
    private final String snapshotId;
    private final String status;
    private final String statusMessage;
    private final String url;
    private final UserBucketDetails userBucket;

    private SnapshotDetail(BuilderImpl builder) {
        this.description = builder.description;
        this.deviceName = builder.deviceName;
        this.diskImageSize = builder.diskImageSize;
        this.format = builder.format;
        this.progress = builder.progress;
        this.snapshotId = builder.snapshotId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.url = builder.url;
        this.userBucket = builder.userBucket;
    }

    public String description() {
        return this.description;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public Double diskImageSize() {
        return this.diskImageSize;
    }

    public String format() {
        return this.format;
    }

    public String progress() {
        return this.progress;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public String status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String url() {
        return this.url;
    }

    public UserBucketDetails userBucket() {
        return this.userBucket;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskImageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.userBucket());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotDetail)) {
            return false;
        }
        SnapshotDetail other = (SnapshotDetail)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.diskImageSize(), other.diskImageSize()) && Objects.equals(this.format(), other.format()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.userBucket(), other.userBucket());
    }

    public String toString() {
        return ToString.builder((String)"SnapshotDetail").add("Description", (Object)this.description()).add("DeviceName", (Object)this.deviceName()).add("DiskImageSize", (Object)this.diskImageSize()).add("Format", (Object)this.format()).add("Progress", (Object)this.progress()).add("SnapshotId", (Object)this.snapshotId()).add("Status", (Object)this.status()).add("StatusMessage", (Object)this.statusMessage()).add("Url", (Object)this.url()).add("UserBucket", (Object)this.userBucket()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "DiskImageSize": {
                return Optional.ofNullable(clazz.cast(this.diskImageSize()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "UserBucket": {
                return Optional.ofNullable(clazz.cast(this.userBucket()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String deviceName;
        private Double diskImageSize;
        private String format;
        private String progress;
        private String snapshotId;
        private String status;
        private String statusMessage;
        private String url;
        private UserBucketDetails userBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotDetail model) {
            this.description(model.description);
            this.deviceName(model.deviceName);
            this.diskImageSize(model.diskImageSize);
            this.format(model.format);
            this.progress(model.progress);
            this.snapshotId(model.snapshotId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.url(model.url);
            this.userBucket(model.userBucket);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final Double getDiskImageSize() {
            return this.diskImageSize;
        }

        @Override
        public final Builder diskImageSize(Double diskImageSize) {
            this.diskImageSize = diskImageSize;
            return this;
        }

        public final void setDiskImageSize(Double diskImageSize) {
            this.diskImageSize = diskImageSize;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getProgress() {
            return this.progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final UserBucketDetails.Builder getUserBucket() {
            return this.userBucket != null ? this.userBucket.toBuilder() : null;
        }

        @Override
        public final Builder userBucket(UserBucketDetails userBucket) {
            this.userBucket = userBucket;
            return this;
        }

        public final void setUserBucket(UserBucketDetails.BuilderImpl userBucket) {
            this.userBucket = userBucket != null ? userBucket.build() : null;
        }

        public SnapshotDetail build() {
            return new SnapshotDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SnapshotDetail> {
        public Builder description(String var1);

        public Builder deviceName(String var1);

        public Builder diskImageSize(Double var1);

        public Builder format(String var1);

        public Builder progress(String var1);

        public Builder snapshotId(String var1);

        public Builder status(String var1);

        public Builder statusMessage(String var1);

        public Builder url(String var1);

        public Builder userBucket(UserBucketDetails var1);

        default public Builder userBucket(Consumer<UserBucketDetails.Builder> userBucket) {
            return this.userBucket((UserBucketDetails)((UserBucketDetails.Builder)UserBucketDetails.builder().applyMutation(userBucket)).build());
        }
    }
}

