/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionedBandwidth
implements ToCopyableBuilder<Builder, ProvisionedBandwidth> {
    private final Instant provisionTime;
    private final String provisioned;
    private final Instant requestTime;
    private final String requested;
    private final String status;

    private ProvisionedBandwidth(BuilderImpl builder) {
        this.provisionTime = builder.provisionTime;
        this.provisioned = builder.provisioned;
        this.requestTime = builder.requestTime;
        this.requested = builder.requested;
        this.status = builder.status;
    }

    public Instant provisionTime() {
        return this.provisionTime;
    }

    public String provisioned() {
        return this.provisioned;
    }

    public Instant requestTime() {
        return this.requestTime;
    }

    public String requested() {
        return this.requested;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioned());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.requested());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedBandwidth)) {
            return false;
        }
        ProvisionedBandwidth other = (ProvisionedBandwidth)obj;
        return Objects.equals(this.provisionTime(), other.provisionTime()) && Objects.equals(this.provisioned(), other.provisioned()) && Objects.equals(this.requestTime(), other.requestTime()) && Objects.equals(this.requested(), other.requested()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"ProvisionedBandwidth").add("ProvisionTime", (Object)this.provisionTime()).add("Provisioned", (Object)this.provisioned()).add("RequestTime", (Object)this.requestTime()).add("Requested", (Object)this.requested()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionTime": {
                return Optional.ofNullable(clazz.cast(this.provisionTime()));
            }
            case "Provisioned": {
                return Optional.ofNullable(clazz.cast(this.provisioned()));
            }
            case "RequestTime": {
                return Optional.ofNullable(clazz.cast(this.requestTime()));
            }
            case "Requested": {
                return Optional.ofNullable(clazz.cast(this.requested()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Instant provisionTime;
        private String provisioned;
        private Instant requestTime;
        private String requested;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedBandwidth model) {
            this.provisionTime(model.provisionTime);
            this.provisioned(model.provisioned);
            this.requestTime(model.requestTime);
            this.requested(model.requested);
            this.status(model.status);
        }

        public final Instant getProvisionTime() {
            return this.provisionTime;
        }

        @Override
        public final Builder provisionTime(Instant provisionTime) {
            this.provisionTime = provisionTime;
            return this;
        }

        public final void setProvisionTime(Instant provisionTime) {
            this.provisionTime = provisionTime;
        }

        public final String getProvisioned() {
            return this.provisioned;
        }

        @Override
        public final Builder provisioned(String provisioned) {
            this.provisioned = provisioned;
            return this;
        }

        public final void setProvisioned(String provisioned) {
            this.provisioned = provisioned;
        }

        public final Instant getRequestTime() {
            return this.requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        public final String getRequested() {
            return this.requested;
        }

        @Override
        public final Builder requested(String requested) {
            this.requested = requested;
            return this;
        }

        public final void setRequested(String requested) {
            this.requested = requested;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public ProvisionedBandwidth build() {
            return new ProvisionedBandwidth(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProvisionedBandwidth> {
        public Builder provisionTime(Instant var1);

        public Builder provisioned(String var1);

        public Builder requestTime(Instant var1);

        public Builder requested(String var1);

        public Builder status(String var1);
    }
}

