/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.LaunchPermission;
import software.amazon.awssdk.services.ec2.model.LaunchPermissionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchPermissionModifications
implements ToCopyableBuilder<Builder, LaunchPermissionModifications> {
    private final List<LaunchPermission> add;
    private final List<LaunchPermission> remove;

    private LaunchPermissionModifications(BuilderImpl builder) {
        this.add = builder.add;
        this.remove = builder.remove;
    }

    public List<LaunchPermission> add() {
        return this.add;
    }

    public List<LaunchPermission> remove() {
        return this.remove;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.add());
        hashCode = 31 * hashCode + Objects.hashCode(this.remove());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchPermissionModifications)) {
            return false;
        }
        LaunchPermissionModifications other = (LaunchPermissionModifications)obj;
        return Objects.equals(this.add(), other.add()) && Objects.equals(this.remove(), other.remove());
    }

    public String toString() {
        return ToString.builder((String)"LaunchPermissionModifications").add("Add", this.add()).add("Remove", this.remove()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Add": {
                return Optional.ofNullable(clazz.cast(this.add()));
            }
            case "Remove": {
                return Optional.ofNullable(clazz.cast(this.remove()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<LaunchPermission> add = DefaultSdkAutoConstructList.getInstance();
        private List<LaunchPermission> remove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchPermissionModifications model) {
            this.add(model.add);
            this.remove(model.remove);
        }

        public final Collection<LaunchPermission.Builder> getAdd() {
            return this.add != null ? (Collection)this.add.stream().map(LaunchPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder add(Collection<LaunchPermission> add) {
            this.add = LaunchPermissionListCopier.copy(add);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder add(LaunchPermission ... add) {
            this.add(Arrays.asList(add));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder add(Consumer<LaunchPermission.Builder> ... add) {
            this.add(Stream.of(add).map(c -> (LaunchPermission)((LaunchPermission.Builder)LaunchPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdd(Collection<LaunchPermission.BuilderImpl> add) {
            this.add = LaunchPermissionListCopier.copyFromBuilder(add);
        }

        public final Collection<LaunchPermission.Builder> getRemove() {
            return this.remove != null ? (Collection)this.remove.stream().map(LaunchPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remove(Collection<LaunchPermission> remove) {
            this.remove = LaunchPermissionListCopier.copy(remove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remove(LaunchPermission ... remove) {
            this.remove(Arrays.asList(remove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remove(Consumer<LaunchPermission.Builder> ... remove) {
            this.remove(Stream.of(remove).map(c -> (LaunchPermission)((LaunchPermission.Builder)LaunchPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRemove(Collection<LaunchPermission.BuilderImpl> remove) {
            this.remove = LaunchPermissionListCopier.copyFromBuilder(remove);
        }

        public LaunchPermissionModifications build() {
            return new LaunchPermissionModifications(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LaunchPermissionModifications> {
        public Builder add(Collection<LaunchPermission> var1);

        public Builder add(LaunchPermission ... var1);

        public Builder add(Consumer<LaunchPermission.Builder> ... var1);

        public Builder remove(Collection<LaunchPermission> var1);

        public Builder remove(LaunchPermission ... var1);

        public Builder remove(Consumer<LaunchPermission.Builder> ... var1);
    }
}

